


XPR(1)              UNIX Programmer's Manual               XPR(1)



NAME
     xpr - print X window dump

SYNOPSIS
     xpr [ -scale _s_c_a_l_e ] [ -height _i_n_c_h_e_s ] [ -width _i_n_c_h_e_s ] [
     -left _i_n_c_h_e_s ] [ -top _i_n_c_h_e_s ] [ -header _s_t_r_i_n_g ] [ -trailer
     _s_t_r_i_n_g ] [ -landscape ] [ -portrait ] [ -output _f_i_l_e_n_a_m_e ] [
     -append _f_i_l_e_n_a_m_e ] [ -noff ] [ -split _n ] [ -device _d_e_v ] [
     _f_i_l_e_n_a_m_e ]

DESCRIPTION
     _X_p_r takes as input an X window dump file produced by _x_w_d(1)
     and formats it for output on the LN03 or LA100 printer.  If
     no file argument is given, the standard input is used.  By
     default, _x_p_r prints the largest possible representation of
     the window on the output page.  Options allow the user to
     add headers and trailers, specify margins, adjust the scale
     and orientation, and append multiple window dumps to a sin-
     gle output file.  Output is to standard output unless -out-
     put is specified.

     Command Options


     -scale _s_c_a_l_e
          Affects the size of the window on the page.  The LN03
          is able to translate each bit in a window pixel map
          into a grid of a specified size.  For example each bit
          might translate into a 3x3 grid.  This would be speci-
          fied by -scale _3.  By default a window is printed with
          the largest scale that will fit onto the page for the
          specified orientation.

     -height _i_n_c_h_e_s
          Specifies the maximum height of the window on the page.

     -width _i_n_c_h_e_s
          Specifies the maximum width of the window.

     -left _i_n_c_h_e_s
          Specifies the left margin in inches.  Fractions are
          allowed.  By default the window is centered in the
          page.

     -top _i_n_c_h_e_s
          Specifies the top margin for the picture in inches.
          Fractions are allowed.

     -header _h_e_a_d_e_r
          Specifies a header string to be printed above the win-
          dow.




Printed 12/6/86          27 August 1985                         1






XPR(1)              UNIX Programmer's Manual               XPR(1)



     -trailer _t_r_a_i_l_e_r
          Specifies a trailer string to be printed below the win-
          dow.

     -landscape
          Forces the window to printed in landscape mode.  By
          default a window is printed such that its longest side
          follows the long side of the paper.

     -portrait
          Forces the window to be printed in portrait mode.  By
          default a window is printed such that its longest side
          follows the long side of the paper.

     -output _f_i_l_e_n_a_m_e
          Specifies an output file name.  If this option is not
          specified, standard output is used.

     -append _f_i_l_e_n_a_m_e
          Specifies a filename previously produced by _x_p_r to
          which the window is to be appended.

     -noff
          When specified in conjunction with -append, the window
          will appear on the same page as the previous window.

     -split _n
          This option allows the user to split a window onto
          several pages. This might be necessary for very large
          windows that would otherwise cause the printer to over-
          load and print the page in an obscure manner.

     -device _d_e_v_i_c_e
          Specifies the device on which the file will be printed.
          Currently only the LN03 and LA100 are supported.

SEE ALSO
     xwd(1), xdpr(1), xwud(1), X(1)

LIMITATIONS
     The current version of _x_p_r can generally  print out on  the
     LN03 most X  windows that are not   larger than two-thirds
     of the screen.  For example, it will be able to print out a
     large Emacs  window,  but it will usually fail when trying
     to print out the  entire screen.  The LN03 has memory  limi-
     tations that can cause it  to  incorrectly  print very
     large or complex    windows.    The two   most common
     errors encountered  are ``band  too  complex'' and ``page
     memory exceeded.'' In the first case, a window may have  a
     particular six  pixel row that contains too many  changes
     (from black to  white to black).  This will cause the
     printer to drop part of the line  and possibly  parts of the



Printed 12/6/86          27 August 1985                         2






XPR(1)              UNIX Programmer's Manual               XPR(1)



     rest of the page.  The printer will flash the  number `1' on
     its front panel when this problem occurs.  A  possible solu-
     tion  to this problem is to increase the scale of the pic-
     ture, or to split the picture  onto two  or  more pages.
     The second problem,   ``page memory exceeded,'' will occur
     if the picture contains too much  black, or if the  picture
     contains    complex half-tones such   as   the  background
     color of a display.  When this   problem occurs  the
     printer will  automatically split the picture  into two or
     more pages.   It may  flash the number `5' on  its from
     panel.   There  is no easy  solution to this problem.  It
     will probably be  necessary to either  cut  and paste, or
     rework to application to produce a less complex picture.

     _X_p_r provides some support  for the  LA100.   However, there
     are several limitations on its use: The picture will  always
     be printed in portrait mode (this  may  be  changed  in the
     future;)   there   is no scaling; and the aspect ratio will
     be slightly off.

AUTHOR
     Copyright 1985, Massachusetts Institute of Technology

     Michael R. Gretzinger, MIT Project Athena































Printed 12/6/86          27 August 1985                         3



