


BURST(1)            UNIX Programmer's Manual             BURST(1)



NAME
     burst - explode digests into messages

SYNOPSIS
     burst [+folder] [msgs] [-inplace] [-noinplace] [-quiet]
          [-noquiet] [-verbose] [-noverbose] [-help]
9     _B_u_r_s_t considers the specified messages in the named folder
     to be Internet digests, and explodes them in that folder.

     If `-inplace' is given, each digest is replaced by the
     "table of contents" for the digest (the original digest is
     removed).  _B_u_r_s_t then renumbers all of the messages follow-
     ing the digest in the folder to make room for each of the
     messages contained within the digest.  These messages are
     placed immediately after the digest.

     If `-noinplace' is given, each digest is preserved, no table
     of contents is produced, and the messages contained within
     the digest are placed at the end of the folder.  Other mes-
     sages are not tampered with in any way.

     The `-quiet' switch directs _b_u_r_s_t to be silent about report-
     ing messages that are not in digest format.

     The `-verbose' switch directs _b_u_r_s_t to tell the user the
     general actions that it is taking to explode the digest.

     It turns out that _b_u_r_s_t works equally well on forwarded mes-
     sages and blind-carbon-copies as on Internet digests, pro-
     vided that the former two were generated by _f_o_r_w or _s_e_n_d.

FILES
     $HOME/.mh_profile                  The user profile

PROFILE COMPONENTS
     Path:                To determine the user's MH directory
     Current-Folder:      To find the default current folder
     Msg-Protect:         To set mode when creating a new message

SEE ALSO
     _P_r_o_p_o_s_e_d _S_t_a_n_d_a_r_d _f_o_r _M_e_s_s_a_g_e _E_n_c_a_p_s_u_l_a_t_i_o_n (aka RFC-934),
     inc(1), msh(1), pack(1)

DEFAULTS
     `+folder' defaults to the current folder
     `msgs' defaults to cur
     `-noinplace'
     `-noquiet'
     `-noverbose'


9


Printed 1/10/87                MH                               1






BURST(1)            UNIX Programmer's Manual             BURST(1)



CONTEXT
     If a folder is given, it will become the current folder.  If
     `-inplace' is given, then the first message burst becomes
     the current message.  This leaves the context ready for a
     _s_h_o_w of the table of contents of the digest, and a _n_e_x_t to
     see the first message of the digest.  If `-noinplace' is
     given, then the first message extracted from the first dig-
     est burst becomes the current message.  This leaves the con-
     text in a similar, but not identical, state to the context
     achieved when using `-inplace'.

BUGS
     The _b_u_r_s_t program enforces a limit on the number of messages
     which may be _b_u_r_s_t from a single message.  This number is on
     the order of 1000 messages.  There is usually no limit on
     the number of messages which may reside in the folder after
     the _b_u_r_s_ting.

     Although _b_u_r_s_t uses a sophisticated algorithm to determine
     where one encapsulated message ends and another begins, not
     all digestifying programs use an encapsulation algorithm.
     In degenerate cases, this usually results in _b_u_r_s_t finding
     an encapsulation boundary prematurely and splitting a single
     encapsulated message into two or more messages.  These
     erroneous digestifying programs should be fixed.

     Furthermore, any text which appears after the last encapsu-
     lated message is not placed in a seperate message by _b_u_r_s_t.
     In the case of digestified messages, this text is usally an
     "End of digest" string.  As a result of this possibly
     un-friendly behavior on the part of _b_u_r_s_t, note that when
     the `-inplace' option is used, this trailing information is
     lost.  In practice, this is not a problem since correspon-
     dents usually place remarks in text prior to the first
     encapsulated message, and this information is not lost.




















Printed 1/10/87                MH                               2



