.TH "XNSARCHIVE" 1 "3-MAR-87" "Xerox (WRC)"
.\" $Header: xnsarchive.n,v 1.1 87/04/01 13:56:18 ed Exp $
.SH NAME
xnsarchive - Archive facility for XNS file servers
.SH SYNOPSIS
.B xnsarchive 
[
.B \-u
] [
.B \-v
] [
.B -l log-file
]
.B remote-file local-file
.SH DESCRIPTION
.I Xnsarchive
serializes the file named in \fIremote-file\fR into the file on the local
host named by \fIlocal-file\fR. The serialized format maintains both content
and attributes for the remote file and any descendant files if the file is
a directory. The resulting file can then be written to tape for archival
purposes.
.PP
If \fIlocal-file\fR is \*(lq-\*(rq, then the output will be written to
\fIstdout\fR. This is useful for piping to other programs directly.
.PP
The arguments specified in \fIremote-file1\fR may be in one
of the following three forms, where host is a Clearinghouse name of the form 
\fIobject:domain:organization\fR (domain and organization are optional):
.nf
	[host]filename
	(host)filename
	host:filename
.fi
.PP
Credentials for accessing the remote service are determined either from the 
environment variables XNSNAME and XNSPASSWD or, if not defined, by prompting 
the user.
.PP
The possible options are:
.TP
.BI -l \ log-file
causes a summary of all files archived to be written to \fIlog-file\fR.
.TP
.B -u
causes the access list of the file named in \fIremote-file\fR to be propogated
to all descendants to eliminate potential access conflicts during 
serialization.
.TP
.B -v
causes informational messages to be written to \fIstderr\fR along the way.
.SH "SEE ALSO"
xnsrestore(1N), xnscreds(1N)
.br
Filing Protocol, \s8XSIS\s0 108605 (May 1986)
.SH AUTHORS
Ed Flint

