.TH GETCOURIERDBENT 3  Cornell
.\" $Header: getcourierdbent.n,v 1.1 86/11/19 07:32:41 jqj Exp $
.SH NAME
getcourierdbent, getcourierservice, setcourierdbent, endcourierdbent \-
get courier service entry
.SH SYNOPSIS
.nf
.B #include <xnscourier/courierdb.h>
.PP
.B struct courierdbent *getcourierdbent()
.PP
.B struct courierdbent *getcourierservice(program,version)
.B unsigned long program;
.B unsigned short version;
.PP
.B setcourierdbent()
.PP
.B endcourierdbent()
.fi
.SH DESCRIPTION
.I Getcourierdbent
and
.I getcourierservice
each return a pointer to an object with the
following structure
containing the broken-out
fields of a line in the Courier services file, describing one service
defined on this machine.
.RS
.PP
.nf
.so /usr/include/xnscourier/courierdb.h
.ft R
.ad
.fi
.RE
.PP
Each entry describes one program contained in the database of Courier
programs known on this system.  The
.I cr_description
field contains a pointer to a string containing the full path name of
the Courier description (used in DEPENDS UPON constructs from other
Courier descriptions.
The
.I cr_serverbin
contains either NULL to indicate that no server for this program exists,
or the full path name of the executable file which implements the
server.
.PP
.I Getcourierdbent
reads the next
line (opening the file if necessary);
.I setcourierdbent
rewinds the file;
.I endcourierdbent
closes it.
.PP
.I Getcourierservice
searches from the beginning until a matching
.I program
and
.I version
is found
(or until EOF is encountered).
.SH FILES
/etc/Courierservices
.SH "SEE ALSO"
Xerox courier specification.
.SH DIAGNOSTICS
Null pointer
(0) returned on EOF or error.
.SH BUGS
All information
is contained in a static area
so it must be copied if it is
to be saved.
.br
