.TH "AUTH_GETFIRSTAUTH" 3 "29-Dec-86" "Xerox (WRC)"
.\" $Header: authlookup.n,v 1.1 87/01/15 16:48:08 ed Exp $
.SH NAME
Auth_GetFirstAuth
\- Locate an Authentication service.
.SH SYNOPSIS
.PP
.nf
.B "#include <sys/types.h>		/* used by ns.h */"
.B "#include <netns/ns.h>		/* for sockaddr_ns */"
.B "#include <xnscourier/courier.h>"
.B "#include <xnscourier/courierconnection.h>"
.PP
.B "CourierConnection *Auth_GetFirstAuth()"
.f
.PP
Link with
.IR "-lcourier" .
.SH DESCRIPTION
The routine
.I Auth_GetFirstAuth
returns an XNS Courier connection to a nearby Authentication service, useful
for Authentication remote procedure calls.
.I Xnsbfs 
is used to perform a broadcast for Authentication servers, the results of
which are then used to open a Courier connection. If no Authentication servers
respond to the broadcast or a connection cannot be established to a service,
NULL is returned.
.SH NOTES
A CourierConnection is an anonymous data structure used by the
runtimes.  Users should not dereference pointers to CourierConnection
themselves.
.SH FILES
/usr/local/lib/libcourier.a		-lcourier library.
.SH SEE ALSO
xnsbfs(1N)
.br
``XNS Courier Under Unix''
.br
Authentication Protocol, \s8XSIS\s0 098404 (April 1984).
.SH AUTHOR
Ed Flint

