.TH XNSFTP L "20 June 1985"
.UC 4
.SH NAME
xnsftp \-file transfer program
.SH SYNOPSIS
.B ftp
[ 
.B \-v
] [
.B \-d
] [
.B \-i
] [
.B \-n
] [
.B \-g
] [
.B host
]
.SH DESCRIPTION
.I Xnsftp
is a user interface to the XNS Courier Filing protocol.
The program allows a user to transfer files to and from a
remote network site running Filing (version 4) server software,
typically a Xerox file server.
.PP
The server host with which 
.I xnsftp
is to communicate may be specified on the command line.
If this is done,
.I xnsftp
will immediately attempt to establish a connection to a Filing server
server on that host; otherwise, 
.I xnsftp
will enter its command interpreter and await instructions
from the user.  When 
.I xnsftp
is awaiting commands from the user the prompt \*(lqxnsftp>\*(rq
is provided the user.  The following commands are recognized
by
.IR xnsftp :
.TP
.B \&!
Invoke a shell on the local machine.
.TP
\fBappend\fP \fIlocal-file\fP [ \fIremote-file\fP ]
Not yet implemented!
Append a local file to a file on the remote machine.
If
.I remote-file
is left unspecified, the local file name is used in naming the
remote file.  File transfer uses the current settings for
.IR type ,
.IR format ,
.IR mode ,
and
.IR structure .
.TP
.B ascii
Set the file transfer 
.I type
to network ASCII.  This is the default type, and is appropriate for
transferring 7-bit ascii text files.
.TP
.B bell
Arrange that a bell be sounded after each file transfer
command is completed.
.TP
.B binary
Set the file transfer
.I type
to support binary image transfer.
This is the appropriate type for transferring 8-bit binary data, e.g. Interlisp
DCOM files.
.TP
.B bye
Terminate the FTP session with the remote server
and exit
.IR xnsftp .
.TP
.BI cd " remote-directory"
Change the working directory on the remote machine
to 
.IR remote-directory .
.TP
.B close
Terminate the FTP session with the remote server, and
return to the command interpreter.
.TP
.BI delete " remote-file"
Delete the file
.I remote-file
on the remote machine.
If the remote file is a directory a confirmation will be required.
.TP
\fBdebug\fP [ \fIdebug-value\fP ]
Toggle debugging mode.  If an optional
.I debug-value
is specified it is used to set the debugging level.
.TP
\fBdir\fP [ \fIremote-directory\fP ] [ \fIlocal-file\fP ]
Print a listing of the directory contents in the
directory,
.IR remote-directory ,
and, optionally, placing the output in
.IR local-file .
If no directory is specified, the current working
directory on the remote machine is used.  If no local
file is specified, output comes to the terminal.
.TP
.BI form " format"
Set the file transfer 
.I form
to 
.IR format .
The default format, and the only one currently supported, is \*(lqfile\*(rq.
.TP
\fBget\fP \fIremote-file\fP [ \fIlocal-file\fP ]
Retrieve the 
.I remote-file
and store it on the local machine.  If the local
file name is not specified, it is given the same
name it has on the remote machine.
The current settings for 
.IR type ,
.IR form ,
.IR mode ,
and
.I structure
are used while transferring the file.
.TP
\fBhash\f
Toggle hash-sign (``#'') printing for each data block
transferred.  Data blocks vary depending on implementation, but
are typically 534 bytes long.
.TP
.B glob
Toggle file name globbing.  With file name globbing enabled,
each local file or pathname is processed for 
.IR csh (1)
metacharacters.  These characters include ``*?[]~{}''.
Remote files specified in mutliple item commands, e.g.
.IR mput ,
are globbed by the remote server.  With globbing disabled
all files and pathnames are treated literally.
.TP
\fBhelp\fP [ \fIcommand\fP ]
Print an informative message about the meaning of
.IR command .
If no argument is given, 
.I xnsftp
prints a list of the known commands.
.TP
\fBlcd\fP [ \fIdirectory\fP ]
Change the working directory on the local machine.  If
no 
.I directory
is specified, the user's home directory is used.
.TP
\fBls\fP [ \fIremote-directory\fP ] [ \fIlocal-file\fP ]
Print an abbreviated listing (containing remote path names) of the contents of a
directory on the remote machine.  If
.I remote-directory
is left unspecified, the current working directory
is used.  If no local file is specified, the output
is sent to the terminal.
.TP
\fBmdelete\fP \fIremote-files\fP
Delete the specified files on the remote machine.  If globbing
is enabled, the specification of remote files will first be
expanded using
.IR ls .
.TP
\fBmdir\fP \fIremote-files\fP \fIlocal-file\fP
Obtain a directory listing of multiple files on the remote
machine and place the result in
.IR local-file .
.TP
\fBmget\fP \fIremote-files\fP
Retrieve the specified files from the remote machine and
place them in the current local directory.  If globbing
is enabled, the specification of remote files will first be
expanding using
.IR ls .
The local file names will be identical with the name attribute of
the remote file names i.e. with the last component of the remote pathname.
.TP
\fBmkdir\fP \fIdirectory-name\fP
Make a directory on the remote machine.
.TP
\fBmls\fP \fIremote-files\fP \fIlocal-file\fP
Obtain an abbreviated listing of multiple files on the remote
machine and place the result in
.IR local-file .
.TP
\fBmode\fP [ \fImode-name\fP ]
Set the file transfer
.I mode
to
.IR mode-name .
The default mode, and the only one currently supported,
is \*(lqstream\*(rq mode.
.TP
\fBmput\fP \fIlocal-files\fP
Transfer multiple local files from the current local directory
to the current working directory on the remote machine.
.TP
\fBopen\fP \fIhost\fP [ \fIport\fP ]
Establish a connection to the specified
.I host
Filing server.
Note that
.I host
must be the Clearinghouse name of a Filing server, e.g. 
\*(lqcornellfs1:computer\ science:cornell-univ\*(rq; if the domain
and organization components of the name are not specified, they default
to the local domain and organization.
If the 
.I auto-login
option is on (default), 
.I xnsftp
will also attempt to automatically log the user in to
the Filing server (see below).
.TP
.B prompt
Toggle interactive prompting.  Interactive prompting
occurs during multiple file transfers to allow the
user to selectively retrieve or store files.  If
prompting is turned off (default), any
.I mget
or
.I mput
will transfer all files.
.TP
\fBput\fP \fIlocal-file\fP [ \fIremote-file\fP ]
Store a local file on the remote machine.  If 
.I remote-file
is left unspecified, the local file name is used
in naming the remote file.  File transfer uses the
current settings for
.IR type ,
.IR format ,
.IR mode ,
and
.IR structure .
.TP
.B pwd
Print the name of the current working directory on the remote
machine.
.TP
.B quit
A synonym for bye.
.TP
\fBrename\fP [ \fIfrom\fP ] [ \fIto\fP ]
Not yet implemented!
Rename the file
.I from
on the remote machine, to the file
.IR to .
.TP
.BI rmdir " directory-name"
Delete a directory on the remote machine.
.TP
\fBsend\fP \fIlocal-file\fP [ \fIremote-file\fP ]
A synonym for put.
.TP
.B status
Show the current status of
.IR xnsftp .
.TP
\fBstruct\fP [ \fIstruct-name\fP ]
Set the file transfer
.I structure
to
.IR struct-name .
By default \*(lqstream\*(rq structure is used.
This is also the only structure currently supported.
.TP
.B trace
Toggle packet tracing.
.TP
\fBtype\fP [ \fItype-name\fP ]
Set the file transfer
.I type
to
.IR type-name .
If no type is specified, the current type
is printed.  The default type is network ASCII.
Only ASCII and BINARY types are currently supported.
.TP
\fBuser\fP \fIuser-name\fP [ \fIpassword\fP ]
Identify yourself to the remote Filing server.  If the
password is not specified and the server requires it,
.I xnsftp
will prompt the user for it (after disabling local echo).
Unless
.I xnsftp
is invoked with \*(lqauto-login\*(rq disabled, this
process is done automatically on initial connection to
the Filing server.
The user name should be a standard XNS Clearinghouse name or alias, e.g.
\*(lqj.q.\ johnson:computer\ science:cornell-univ\*(rq; if the domain
and organization components of the name are not specified, they default
to the local domain and organization.
.TP
.B verbose
Toggle verbose mode.  In verbose mode, all responses from
the Filing server are displayed to the user.  In addition,
if verbose is on, when a file transfer completes, statistics
regarding the efficiency of the transfer are reported.  By default,
verbose is on.
.TP
\fB?\fP [ \fIcommand\fP ]
A synonym for help.
.PP
Command arguments which have embedded spaces may be quoted with
quote (") marks.
.PP
.SH "FILE NAMING CONVENTIONS"
Files specified as arguments to
.I xnsftp
commands are processed according to the following rules.
.TP
1)
If the file name \*(lq\-\*(rq is specified, the
.B stdin
(for reading) or
.B stdout
(for writing) is used.
.TP
2)
If the first character of the file name is \*(lq|\*(rq, the
remainder of the argument is interpreted as a shell command.
.I Xnsftp
then forks a shell, using 
.IR popen (3)
with the argument supplied, and reads (writes) from the stdout
(stdin).  If the shell command includes spaces, the argument
must be quoted; e.g. \*(lq"| ls -lt"\*(rq.  A particularly
useful example of this mechanism is: \*(lqdir |more\*(rq.
.TP
3)
Failing the above checks, if ``globbing'' is enabled, 
local file names are expanded
according to the rules used in the 
.IR csh (1);
c.f. the 
.I glob
command. 
.TP
4)
Remote file names whose first character is \*(lq/\*(rq (slash) are interpreted
as absolute pathnames.  Other remote file names are interpreted as pathnames
relative to the current connected directory.
.SH "FILE TRANSFER PARAMETERS"
The FTP specification specifies many parameters which may
affect a file transfer.  The 
.I type
may be one of \*(lqascii\*(rq, \*(lqbinary\*(rq (image),
\*(lqebcdic\*(rq, and \*(lqlocal byte size\*(rq (for PDP-10's
and PDP-20's mostly).
.I Xnsftp
supports the ascii and binary types of file transfer.
ASCII type is appropriate for transferring text files; Unix EOL characters
(\\n) are translated to and from Xerox EOL characters (\\r), Xerox left
arrow characters are translated to underscore, etc.  BINARY (image) type
is appropriate for all other files.
.PP
.I Xnsftp
supports only the default values for the remaining
file transfer parameters: 
.IR mode ,
.IR form ,
and
.IR struct .
.SH OPTIONS
Options may be specified at the command line, or to the 
command interpreter.
.PP
The
.B \-v
(verbose on) option forces
.I xnsftp
to show all responses from the remote server, as well
as report on data transfer statistics.
.PP
The
.B \-n
option restrains 
.I xnsftp
from attempting \*(lqauto-login\*(rq upon initial connection.
.PP
The
.B \-i
option turns off interactive prompting during
mutliple file transfers.
.PP
The
.B \-d
option enables debugging.
.PP
The
.B \-g
option disables file name globbing.
.SH BUGS
Append and Rename are not yet implemented.
.PP
Many interesting features of the Filing protocol, e.g. serialized files
and remote searches using the Find RPC, are not supported.
Also, only version 4 of Filing is supported.
.PP
Aborting a file
transfer does not work right; if one attempts this the connection to
the remote server will likely have to be reopened.
