/*
 * These are the register and offset definitions for the decna
 */
struct dcdevice {
	u_short	rdw;
	u_short	rar;
	u_short	csr;
	u_short	mba;
};
/* The number of receive and transmit buffers. 
 * (NRCV+NXMT) <= 82
 * These are the only parameters to consider changing and
 * even that is not strongly recommended.
 */
#define	NRCV	70
#define	NXMT	10
/* Values for csr */
#define	EPROM	040
#define	RESET	0203
#define	NORMAL	0227
#define	CA	0237
#define	LOOPBK	0207
#define	CALPBK	0217
/* Click address of top of 128k */
#define	SCP	0167777
#define	SCPPTR	((u_short *)0120066)
#define	SCB	0164000		/* Click address of start of 128k */
#define	DCMEM	((SCB>>11)&037)
/* ptrs. to the various blocks in the 128k when mapped into seg5 */
#define	SCBPTR	((u_short *)0120000)
#define	CMDPTR	((u_short *)0120012)
#define	RFDPTR	((u_short *)0120066)
/* Offsets of the various blocks in the SCB, at bottom of 128k.
 * goes something like this:
 * 0 - ISCP
 * 8 - SCB
 * 24- Configure command
 * 42- Address setup command
 * 54- 1st. RFD
 * 76- 1st. RBD
 * 86- 2nd. RFD
 * ... for NRCV times
 * 2294- 1st. XCMD (actually 54+32*NRCV)
 * 2310- 1st. XBD  (actually XCMD+16)
 * 2318- 2nd. XCMD
 * ... for NXMT times
 * 4096- first Receive buffer
 * 5632- 2nd. Receive buffer
 * ... for NRCV times
 * ... for NXMT times
 */
#define	CMDBASE	8
#define	CNFBASE	24
#define	SADBASE	42
#define	RFDBASE	54
#define	RBDBASE	76
#define	RFDSIZE	32
#define	RCVBASE	4096l
#define	RSIZE	1536l
#define	RCVCLIK	(SCB+64)
#define	RCLICK	24
#define	XCBASE	(RFDBASE+RFDSIZE*NRCV)
#define	XCPTR	((u_short *)(0120000+XCBASE))
#define	XCSIZE	24
#define	XCDBASE	(XCBASE+16)
#define	XMTBASE	(RCVBASE+RSIZE*NRCV)
#define	XSIZE	1536l
/* High order bit marks end of list */
#define	EL	0100000
/* Commands for command word of SCB */
#define	RUSTART	0120020
#define	CUSTART	050400
