#define K	1	/* kills all condition codes */
#define JUMP	2	/* ends a basic block */
#define BYTE	4	/* target is byte offset */
#define C	8	/* kills all condition codes but for C bit*/
/* if((p->type & EXPAND) && p->iname[0] == 'b') replace first char with j */
/* aob and sob get replaced by two instructions */

struct inst {
	char *iname;
	short type;
} insts[] = {
"acbb", C | JUMP,
"acbd", C | JUMP,
"acbf", C | JUMP,
"acbg", C | JUMP,
"acbh", C | JUMP,
"acbl", C | JUMP,
"acbw", C | JUMP,
"adawi", K,
"addb2", K,
"addb3", K,
"addd2", K,
"addd3", K,
"addf2", K,
"addf3", K,
"addg2", K,
"addg3", K,
"addh2", K,
"addh3", K,
"addl2", K,
"addl3", K,
"addp4", K,
"addp6", K,
"addw2", K,
"addw3", K,
"adwc", K,
"aobleq", C | JUMP | BYTE,
"aoblss", C | JUMP | BYTE,
"ashl", C,
"ashp", K,
"ashq", C,
"bbc", JUMP | BYTE,
"bbcc", JUMP | BYTE,
"bbcci", JUMP | BYTE,
"bbcs", JUMP | BYTE,
"bbs", JUMP | BYTE,
"bbsc", JUMP | BYTE,
"bbss", JUMP | BYTE,
"bbssi", JUMP | BYTE,
"bcc", JUMP | BYTE,
"bcs", JUMP | BYTE,
"beql", JUMP | BYTE,
"beqlu", JUMP | BYTE,
"bgeq", JUMP | BYTE,
"bgequ", JUMP | BYTE,
"bgtr", JUMP | BYTE,
"bgtru", JUMP | BYTE,
"bicb2", C,
"bicb3", C,
"bicl2", C,
"bicl3", C,
"bicpsw", K,
"bicw2", C,
"bicw3", C,
"bisb2", C,
"bisb3", C,
"bisl2", C,
"bisl3", C,
"bispsw", K,
"bisw2", C,
"bisw3", C,
"bitb", C,
"bitl", C,
"bitw", C,
"blbc", JUMP | BYTE,
"blbs", JUMP | BYTE,
"bleq", JUMP | BYTE,
"blequ", JUMP | BYTE,
"blss", JUMP | BYTE,
"blssu", JUMP | BYTE,
"bneq", JUMP | BYTE,
"bnequ", JUMP | BYTE,
"bpt",	K,
"brb", JUMP | BYTE,
"brw", JUMP,
"bsbb", JUMP | BYTE,
"bsbw", JUMP,
"bugl", 0,
"bugw", 0,
"bvc", JUMP | BYTE,
"bvs", JUMP | BYTE,
"callg", K,
"calls", K,
"caseb", K | JUMP,
"casel", K | JUMP,
"casew", K | JUMP,
"chme", K,
"chmk", K,
"chms", K,
"chmu", K,
"clrb", C,
"clrd", C,
"clrf", C,
"clrg", C,
"clrh", C,
"clrl", C,
"clro", C,
"clrq", C,
"clrw", C,
"cmpb", K,
"cmpc3", K,
"cmpc5", K,
"cmpd", K,
"cmpf", K,
"cmpg", K,
"cmph", K,
"cmpl", K,
"cmpp3", C,
"cmpp4", C,
"cmpv", K,
"cmpw", K,
"cmpzv", K,
"crc", C,
"cvtbd", K,
"cvtbf", K,
"cvtbg", K,
"cvtbh", K,
"cvtbl", K,
"cvtbw", K,
"cvtdb", K,
"cvtdf", K,
"cvtdh", K,
"cvtdl", K,
"cvtdw", K,
"cvtfb", K,
"cvtfd", K,
"cvtfg", K,
"cvtfh", K,
"cvtfl", K,
"cvtfw", K,
"cvtgb", K,
"cvtgf", K,
"cvtgh", K,
"cvtgl", K,
"cvtgw", K,
"cvthb", K,
"cvthd", K,
"cvthf", K,
"cvthg", K,
"cvthl", K,
"cvthw", K,
"cvtlb", K,
"cvtld", K,
"cvtlf", K,
"cvtlg", K,
"cvtlh", K,
"cvtlp", K,
"cvtlw", K,
"cvtpl", K,
"cvtps", K,
"cvtpt", K,
"cvtrdl", K,
"cvtrfl", K,
"cvtrgl", K,
"cvtrhl", K,
"cvtsp", K,
"cvttp", K,
"cvtwb", K,
"cvtwd", K,
"cvtwf", K,
"cvtwg", K,
"cvtwh", K,
"cvtwl", K,
"decb", K,
"decl", K,
"decw", K,
"divb2", K,
"divb3", K,
"divd2", K,
"divd3", K,
"divf2", K,
"divf3", K,
"divg2", K,
"divg3", K,
"divh2", K,
"divh3", K,
"divl2", K,
"divl3", K,
"divp", K,
"divw2", K,
"divw3", K,
"editpc", K,
"ediv", K,
"emodd", K,
"emodf", K,
"emodg", K,
"emodh", K,
"emul", K,
"escd", 0,
"esce", 0,
"escf", 0,
"extv", K,
"extzv", K,
"ffc", K,
"ffs", K,
"halt",	JUMP,
"incb", K,
"incl", K,
"incw", K,
"index", K,
"insqhi", K,
"insqti", K,
"insque", K,
"insv",	0,
"jbc", JUMP,
"jbcc", JUMP,
"jbcs", JUMP,
"jbr", JUMP,
"jbs", JUMP,
"jbsc", JUMP,
"jbss", JUMP,
"jcc", JUMP,
"jcs", JUMP,
"jeql", JUMP,
"jeqlu", JUMP,
"jgeq", JUMP,
"jgequ", JUMP,
"jgtr", JUMP,
"jgtru", JUMP,
"jlbc", JUMP,
"jlbs", JUMP,
"jleq", JUMP,
"jlequ", JUMP,
"jlss", JUMP,
"jlssu", JUMP,
"jmp", JUMP,
"jneq", JUMP,
"jnequ", JUMP,
"jsb", JUMP,
"jvc", JUMP,
"jvs", JUMP,
"ldpctx", 0,
"locc", K,
"matchc", K,
"mcomb", C,
"mcoml", C,
"mcomw", C,
"mfpr",	C,
"mnegb", K,
"mnegd", K,
"mnegf", K,
"mnegg", K,
"mnegh", K,
"mnegl", K,
"mnegw", K,
"movab", C,
"movad", C,
"movaf", C,
"movag", C,
"movah", C,
"moval", C,
"movao", C,
"movaq", C,
"movaw", C,
"movb",	C,
"movc3", K,
"movc5", K,
"movd",	C,
"movf",	C,
"movg", C,
"movh", C,
"movl",	C,
"movo", C,
"movp", C,
"movpsl", 0,
"movq",	C,
"movtc", K,
"movtuc", K,
"movw",	C,
"movzbl", C,
"movzbw", C,
"movzwl", C,
"mtpr",	C,
"mulb2", K,
"mulb3", K,
"muld2", K,
"muld3", K,
"mulf2", K,
"mulf3", K,
"mulg2", K,
"mulg3", K,
"mulh2", K,
"mulh3", K,
"mull2", K,
"mull3", K,
"mulp", K,
"mulw2", K,
"mulw3", K,
"nop", 0,
"polyd", K,
"polyf", K,
"polyg", K,
"polyh", K,
"popr", 0,
"prober", K,
"probew", K,
"pushab", C,
"pushad", C,
"pushaf", C,
"pushag", C,
"pushah", C,
"pushal", C,
"pushao", C,
"pushaq", C,
"pushaw", C,
"pushl", C,
"pushr", 0,
"rei", K,
"remqhi", K,
"remqti", K,
"remque", K,
"ret", K | JUMP,
"rotl", C,
"rsb", 0,
"sbwc", K,
"scanc", K,
"skpc", K,
"sobgeq", C | JUMP | BYTE,
"sobgtr", C | JUMP | BYTE,
"spanc", K,
"subb2", K,
"subb3", K,
"subd2", K,
"subd3", K,
"subf2", K,
"subf3", K,
"subg2", K,
"subg3", K,
"subh2", K,
"subh3", K,
"subl2", K,
"subl3", K,
"subp4", K,
"subp6", K,
"subw2", K,
"subw3", K,
"svpctx", 0,
"tstb", K,
"tstd", K,
"tstf", K,
"tstg", K,
"tstl", K,
"tstw", K,
"tstw", K,
"xfc",	K | JUMP,
"xorb2", C,
"xorb3", C,
"xorl2", C,
"xorl3", C,
"xorw2", C,
"xorw3", C,
0, 0
};
