      SUBROUTINE D8XTRO(E,NX,M,MMAX,KMAX,LOGN,GAMMA,F,POW,KOPT,
     1                  DT,HOPT,LNWORK,COST,LOGLO,LOGHI)
C
C  COMPUTE THE OPTIMAL K AND H.
C
      DOUBLE PRECISION LOGN(MMAX),GAMMA,DT,TEMP
      REAL E(NX,KMAX),F(KMAX),POW(KMAX),
     1     HOPT(1),LNWORK(MMAX),COST(1),LOGLO,LOGHI
C     REAL HOPT(KMAX+1),COST(KMAX+1)
C
      REAL RHOMAX,HOPTK,ROMAX,HOPTM,HTOL,LOGDT
C
C  HTOL IS THE RELATIVE TOLERANCE TO WHICH LOG(HOPT) WILL BE COMPUTED.
C
      DATA HTOL/5.0E-2/
C
      LOGDT=ALOG(SNGL(DABS(DT)))
      KHI=MIN0(M-1,KMAX)
      KHIP1=KHI+1
      KOPT=1
C
C ... COMPUTE HOPT(K), K=1,...,MIN(M,KMAX+1).
C
      DO 50 K=1,KHIP1
C
         JHI=MIN0(K,KHI)
         JHIM1=JHI-1
C
C ...... COMPUTE THE FACTORS WHICH CONVERT ERRORS INTO STEP-SIZES.
C
         DO 20 J=1,JHI
C
            MMA=M
            LMA=K+1
            TEMP=0.0E0
C
            DO 10 I=1,J
C
               LMA=LMA-1
               MMA=MMA-1
 10            TEMP=TEMP+(LOGN(LMA)-LOGN(MMA))
C
 20         F(J)=GAMMA*TEMP*POW(J)
C
C ...... HOPTK IS THE OPTIMAL STEP-SIZE FOR THE K-COLUMN LOZENGE.
C ...... HOPTM IS THE OPTIMAL STEP-SIZE FOR THE FIRST (K-1)-COLUMNS
C ...... OF THE FULL K-COLUMN LOZENGE.
C
         HOPTK=LOGHI
         HOPTM=LOGHI
C
         DO 40 I=1,NX
C
            RHOMAX=LOGLO
            ROMAX=LOGLO
C
            DO 30 J=1,JHI
C
               RHOMAX=AMAX1(RHOMAX,F(J)+E(I,J))
C
C ............ SAVE THE OPTIMAL FACTOR FOR THE (K-1) COLUMN SUB-LOZENGE.
C
 30            IF (J.EQ.JHIM1) ROMAX=RHOMAX
C
            HOPTM=AMIN1(HOPTM,ROMAX)
 40         HOPTK=AMIN1(HOPTK,RHOMAX)
C
         COST(K)=LNWORK(K+1)-HOPTK
         IF (HOPTK.GT.HOPTM+HTOL.AND.K.LT.KHIP1) KOPT=K
C
 50      HOPT(K)=EXP(AMIN1(HOPTK+LOGDT,0.9999E0*LOGHI))*(DT/DABS(DT))
C
C ... SEE IF A LOWER K IS CHEAPER THAN KOPT. IF SO, USE IT.
C
      DO 60 K=1,KOPT
         KS=K
         IF (COST(K).LE.COST(KOPT)) GO TO 70
 60      CONTINUE
C
 70   KOPT=KS
C
      RETURN
C
      END
