
/*
 *
 * A few system and printer dependent definitions. Most are used to do
 * variable initialization and can easily be changed to suit your own
 * setup.
 *
 *
 *	FONTDIR - binary font file directory. Really only used in dimpress.
 *		  If dimpress is processing a file that was generated for
 *		  printer "xxx" it appends string "/devxxx" to FONTDIR
 *		  to get the real binary font directory pathname. You
 *		  can use the -F option to change the font directory.
 *
 *	BITDIR  - Sort of the same as FONTDIR, but this is for raster
 *		  files instead of font files. Again this guy is really
 *		  only used by dimpress. If you're using raster files for
 *		  device "xxx" then "/rastxxx" is appended to BITDIR to
 *		  get the real raster file directory. Can be changed using
 *		  the -B option.
 *
 *	OLDBITDIR - Really just the same as BITDIR, but its value is used
 *		  when we're printing using the old raster files for the
 *		  Imprint-10. DWB hid them in /usr/lib/font/devi10/rasti10
 *		  and you may have put them somewhere else.
 *
 *	RESDIR -  Printer resident fonts are described in files found in
 *		  directory BITDIR/RESDIR. They're ASCII and usually named
 *		  the same as the target printer. That handles most cases
 *		  but not all, because two otherwise identical printers
 *		  could easily support different resident fonts. The file
 *		  that dimpress uses is *resfile, which by default has
 *		  the same name as the target printer, although it can
 *		  be changed by an option.
 *
 *	RASTDATA - ASCII file found in the final raster directory that
 *		  describes the format and resolution of the raster files.
 *		  It's used by dimpress and can be built by hand or by
 *		  buildrast.
 *
 *	RASTERLIST - Another ASCII file found in the final raster directory.
 *		  Lists the raster file sizes available for all the fonts.
 *		  format is the same as the original file used by di10 or
 *		  dcan. The file must be there for old format raster files,
 *		  but is optional for the new format - although I advise
 * 		  that it be used.
 *
 *	IPR	- Pathname for Imagen's ipr program. A system() call to this
 *		  guy is generated by dimpress (routine print_file()) if we
 *		  haven't invoked the post-processor with the -t option.
 *
 */


#define FONTDIR		"/usr/lib/font"
#define BITDIR		"/usr/lib/raster"
#define RESDIR		"RESIDENT"
#define OLDBITDIR	"/usr/lib/font/devi10"


#define RASTLIST	"RASTERLIST"
#define RASTDATA	"RASTERDATA"

#define IPR		"/usr/bin/ipr"

