/*
 *	proc.h
 *	definition of the process structure
 *
 *	(c) Szigeti Szabolcs	1992 jan 28.
 */

#include "h\prot286.h"

struct	proc
	{
	struct tss p_tss;		/* TaskStateSegment		*/
	struct sys_desc p_ldt[5];	/* Local descriptor table	*/
	word	p_tss_sel;		/* Process's task selector	*/

	struct  user *p_u;		/* ptr to user struct		*/
	word	*p_kstck;		/* Kernel stack kezdete		*/

	byte	p_stat;         	/* see below			*/
	byte  	p_flag;			/* see below			*/
	word	p_wchan;		/* sleep/wakeup event		*/
	pid_t	p_pid;			/* Process ID			*/
	pid_t	p_ppid;			/* Parents PID		*/
	char	p_pri;			/* Actual priority		*/
	byte	p_sig;			/* Signal pending   		*/
	byte	p_cpu;			/* CPU time for scheduling	*/
	char	p_nice;			/* Nice-ness			*/
	char	p_time;			/* Swapping time		*/
	int	p_ttyp;			/* Controlling tty		*/
	struct text *p_textp;		/* Text struct of proc 		*/
	word	p_size; 		/* Swap size			*/
	gaddr_t	p_addr;			/* Swap addr			*/
	uid_t	p_uid;			/* UID for tty signals		*/
	};


extern struct proc proc[];		/* the process table	*/
extern struct proc *cup;		/* ptr to the current p	*/

/* p_stat	*/

#define	SSLEEP	1		/* Sleeping on high priority	*/
#define SWAIT	2		/* Sleeping on low priority	*/
#define SRUN	3		/* Runnable 			*/
#define SIDL	4		/* In creation 			*/
#define	SZOMB	5		/* Exiting			*/
#define SSTOP	6		/* Proc being traced		*/

/* p_flag	*/

#define	SLOAD	01		/* Loaded in core		*/
#define	SSYS	02		/* System process		*/
#define SLOCK	04		/* Locked in core		*/
#define SSWAP	010		/* Swapped out			*/
#define	STRC	020		/* Tracing flag			*/
#define SWTED	040		/* Another tracing flag		*/

/* local selectors	*/

#define TEXTS	  0x00		/* text segment	*/
#define DATAS  	  0x08		/* data segment	*/
#define STACKS    0x10		/* stack segment	*/
#define STACK0S   0x18		/* kernel stack 	*/
#define USTS	  0x20		/* not used	*/
