.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "TERMINAL"
.
          copy      "../systemdef/sysdef"
.
TRBOOT*   mov       r11,r10                   INIT TERMINAL CONTROL BLOCK
          mov       chdrvv(r7),r5             get dev driver vector
          jeq       jlb000                      -> no driver routines
          mov       cvboot(r5),r1             get dev driver boot routine
          bl        *r1                         -> init dev driver

jlb000    mov       r7,r9                     INIT ALL TERMINAL QUEUES
          ai        r9,chiwait                init input wait queue
          blwp      INITQ$
          clr       qn(r9)
          ai        r9,chowait-chiwait        init output wait queue
          blwp      INITQ$
          clr       qn(r9)
          ai        r9,chowork-chowait        init output work queue
          blwp      INITQ$
          clr       qn(r9)
          ai        r9,chomsgq-chowork        init output msg queue
          blwp      INITQ$
          ai        r9,chimsgq-chomsgq        init input msg queue
          blwp      INITQ$
          ai        r9,chiavail-chimsgq       init input available queue
          blwp      INITQ$
          clr       qn(r9)
          ai        r9,chobusy-chiavail       init output concurrency queue
          blwp      INITQ$
          li        r0,TRMOBF                 set queue length to 3
          mov       r0,qn(r9)
          ai        r9,choechl-chobusy        init echo concurrency queue
          blwp      INITQ$
          mov       chechbe(r7),r0            echo buffer end
          s         chechb(r7),r0             - echo buf ptr
          dec       r0                        - 1 = buf len
          mov       r0,qn(r9)                 set queue length to buf length
          ai        r9,chilim-choechl         init input concurrency limit
          blwp      INITQ$
          li        r0,NXTIBK                 set queue length to 3
          mov       r0,qn(r9)
.                                             INIT FLAGS AND BUFFERS
          clr       chechol(r7)               clear echo lock
          clr       chiraw(r7)                clear raw mode
          clr       chinwtg(r7)               clear input wanted flag
          clr       chomsgb(r7)               clear output buffer msg ptr
          clr       chprompt(r7)              clear saved prompt
          mov       chechb(r7),chechip(r7)    set echo insert ptr to buf start
          mov       chechb(r7),chechrp(r7)    set echo delete ptr to buf start
          mov       chibuf(r7),chibip(r7)     set input insert ptr to buf start
          mov       r7,r0                     init circular input buffer
          ai        r0,chicq
          mov       r0,chicqi(r7)             set insert ptr
          mov       r0,chicqr(r7)             set delete ptr
          
          mov       chiline(r7),r9            INITIAL INPUT LINE?
          jeq       jlb001                      -> no, skip
          mov       illen(r9),r1              get initial line length

          ai        r1,mbtext                 BUILD TEXT MESSAGE
          blwp      BGETA$                    build text message
          data      jlb001  
          li        r0,mttext
          mov       r0,mbtype(r1)
          clr       mbrpl(r1)                 no reply queue
          mov       illen(r9),r0
          mov       r0,mblen(r1)
          mov       r1,r8                     copy input line text to buffer
          ai        r1,mbtext
          ai        r9,2
jlb002    movb      *r9+,*r1+
          dec       r0
          jne       jlb002

          mov       r7,r0                     INSERT LINE ON INPUT QUEUE
          ai        r0,chilim                 check type-ahead limit
          blwp      P$
          mov       r7,r9                     when space available,
          ai        r9,chimsgq                post input msg to queue
          blwp      INSERT
          mov       r7,r0
          ai        r0,chiavail               signal input available
          blwp      V$

jlb001    mov       chdrvv(r7),r0             get dev routine vector
          jeq       jlb003                      -> no driver routines
          li        r2,prtermio               terminal service is level 4
          clr       r1                        no process local data needed
          li        r0,rdloop                 start input process
          blwp      FORK$
          li        r0,wrloop                 start output process
          blwp      FORK$
jlb003    b         *r10                      RETURN TO MAIN BOOT SEQUENCE

.
. LINE INPUT / EDIT ROUTINES
.
rdloop    bl        get$ch
          mov       chiraw(r7),r1
          jeq       jlb004  
          b         lbl003

jlb004    cb        r0,lbl004+1               printable character?
          jhe       jlb005                      -> yes
          cb        r0,lbl005+1               is it <CR>?
          jne       jlb006                      -> no, handle other ctrl chars
          b         sndlin                      -> yes, send line

jlb006    cb        r0,lbl005                 is it <BS> (backspace)?
          jeq       jlb007                      -> rub out one character
          cb        r0,lbl007                 is it <CAN>?
          jeq       jlb008                      -> cancel current input line
          cb        r0,lbl008+1               is it <ETB>?
          jeq       jlb009                      -> rub out one element
          cb        r0,lbl007+1               is it <ESC>?
          jeq       jlb00A                      -> insert next char verbatim
          cb        r0,lbl008                 is it <DC3>?
          jeq       jlb00B                      -> toggle echo lock
          cb        r0,lbl009+1               is it <DC2>?
          jeq       jlb00C                      -> retype current line
          cb        r0,lbl00A+1               is it ^C?
          jne       jlb005                      -> no, insert ctrl in input
          b         lbl00B                      -> yes, send interrupt

jlb00C    b         lbl00C

jlb00A    bl        get$ch                    get next character
          bl        ins$ch                    insert raw
          jmp       jlb00D                      -> echo and next

jlb005    bl        ins$ch                    insert character into input line
          cb        r0,lbl004+1               control character?
          jl        ctrlch                      -> yes, print as "^@"-"^_"

jlb00D    bl        echo                      echo char
          mov       r7,r0
          ai        r0,chowork                signal work to do
          blwp      V$
          jmp       rdloop                    process next char
          
get$ch    mov       r7,r0                     GET CHAR FROM DEVICE QUEUE
          ai        r0,chiwait                wait for next character arrival
          blwp      P$
          mov       chicqr(r7),r1
          movb      *r1+,r0                   fetch next char from circ. buffer
          mov       r7,r2
          ai        r2,chicqe
          c         r1,r2                     ptr at end>
          jl        jlb00F                      -> no
          mov       r7,r1                     wrap back to start
          ai        r1,chicq
jlb00F    mov       r1,chicqr(r7)             and write back
          rt

ins$ch    mov       chibip(r7),r1             get input insert ptr         
          c         r1,chibufe(r7)            already full?
          jhe       rdloop                      -> yes, just ignore
          movb      r0,*r1+                   store char in input buffer
          mov       r1,chibip(r7)             update insertion ptr
          seto      chechol(r7)               set echo lock
          rt

ctrlch    swpb      r0                        print ctrl character as ^C, etc.
          movb      lbl004,r0                 print caret
          bl        echo  
          swpb      r0                        add 64 ('@') to ctrl character
          ab        lbl00F+1,r0
          jmp       jlb00D                      -> echo and next


. <BS>: process backspace character
jlb007    c         chibip(r7),chibuf(r7)     no characters typed yet?
          jeq       rdloop                      -> yes, nothing to do
          bl        rubout                    rub out one input
          jmp       rdloop                      -> next char

. <CAN>: cancel input and re-prompt
jlb008    seto      chechol(r7)               set echo lock
          movb      lbl004,r0                 echo "^"
          bl        echo  
          li        r0,05800                  echo "W"
          bl        echo
          li        r3,lbl005+1               echo <CR><LF>
          li        r4,2
jlb010    movb      *r3+,r0
          bl        echo  
          dec       r4
          jne       jlb010
          bl        prompt                    retype prompt
          b         lbl012                      -> erase line & resume loop

. <ETB> : erase one element (single char or "identifier word")
jlb009    c         chibip(r7),chibuf(r7)     input buffer empty?
          jeq       jlb011                      -> done
          mov       chibip(r7),r1             fetch last char
          movb      -1(r1),r0
          bl        iswdch                    in range "A-Za-z0-9$"?
          data      lbl014                      -> yes
          bl        rubout                    rub out one char
          jmp       jlb009                      -> next

lbl014    bl        rubout                    rub out one char
          c         chibip(r7),chibuf(r7)     input buffer empty?
          jeq       jlb011                      -> done
          mov       chibip(r7),r1             fetch last char
          movb      -1(r1),r0
          bl        iswdch                    in range "A-Za-z0-9$"?
          data      lbl014                      -> yes, rub out

jlb011    b         rdloop                      -> no, done

. <DC3>: toggle echo lock
jlb00B    c         chibip(r7),chibuf(r7)     input buffer empty?
          jne       jlb012                      -> done
          inv       chechol(r7)
          jne       jlb012  
          mov       r7,r0
          ai        r0,chowork                signal output
          blwp      V$

jlb012    b         rdloop

. <DC2>: retype current line on new line
lbl00C    movb      lbl004,r0                 ECHO ^ R <CR> <LF>
          bl        echo                      echo caret ("^")
          li        r0,05200                  echo "R"
          bl        echo  
          li        r3,lbl005+1               echo <CR><LF>
          li        r4,2
jlb013    movb      *r3+,r0
          bl        echo  
          dec       r4
          jne       jlb013
          bl        prompt                    retype prompt

          mov       chibuf(r7),r3             RETYPE CURRENT LINE
jlb015    mov       r7,r0
          ai        r0,chowork                signal extra output character
          blwp      V$
          c         r3,chibip(r7)             at end of buffer?
          jhe       jlb014                      -> yes
          movb      *r3+,r0                   echo next character
          bl        echo  
          jmp       jlb015                    do next character

jlb014    b         rdloop
.
. Processs <cr> character in normal input mode
.
sndlin    mov       r7,r0                     HANDLE END OF INPUT LINE
          ai        r0,chilim                 check input limit list
          blwp      PMAY$                     backlog < 3? 
          jeq       jlb014                      -> no, drop line

          mov       chibip(r7),r1             CALC MESSAGE LENGTH
          c         r1,chibufe(r7)            if it fits, add <CR> to line
          jhe       jlb016  
          movb      lbl005+1,*r1+
jlb016    s         chibuf(r7),r1             message length in r1

          mov       r1,r2                     BUILD INPUT LINE MESSAGE
          ai        r1,mbtext
          blwp      BGETA$                    allocate block
          data      rdloop                    no space? -> drop line
          li        r0,mttext
          mov       r0,mbtype(r1)             set type to text
          clr       mbrpl(r1)                 set no reply queue
          mov       r2,mblen(r1)              set len to line length
          
          mov       r1,r8                     COPY INPUT BUFFER TO INPUT MSG
          ai        r1,mbtext
          mov       chibuf(r7),r0
jlb017    mov       *r0+,*r1+                 copy text, word at a time
          dect      r2
          jgt       jlb017

          mov       r7,r9                     
          ai        r9,chimsgq                place on input msg queue                
          blwp      INSERT
          mov       r7,r0                     signal more input available
          ai        r0,chiavail
          blwp      V$

lbl016    mov       chprompt(r7),r1           CLEAR SAVED PROMPT (IF ANY)
          jeq       jlb018                      -> no prompt 
          clr       chprompt(r7)              clear & release saved prompt
          blwp      BREL$

jlb018    li        r3,lbl005+1               ECHO <CR><LF>
          li        r4,2
jlb019    movb      *r3+,r0
          bl        echo  
          dec       r4
          jne       jlb019

lbl012    mov       r7,r0                     ERASE INPUT BUFFER                
          ai        r0,chowork                signal output work
          blwp      V$
          clr       chechol(r7)               clear echo locked flag
          mov       chibuf(r7),chibip(r7)     clear input buffer
          b         rdloop                      -> next character

.
. SEND INTERRUPT MSG (^C RECEIVED)
.
lbl00B    seto      chechol(r7)               set echo lock
          mov       chomsgb(r7),r0            output buffer save
          jeq       jlb01A

          limi      0                         CLEAR OUTPUT BUFFER?
          mov       chocount(r7),r0           remaining output space <= 0?
          jlt       jlb01B  
          jeq       jlb01B  
          mov       one,chocount(r7)          set output space to 1
jlb01B    limi      15

jlb01A    mov       r7,r9                     DROP PENDING OUTPUT MESSAGES
          ai        r9,chomsgq                get next output message
          blwp      REMOVE                    remove from queue
          c         r8,r9                     queue was empty?
          jeq       jlb01C                      -> yes
          mov       r8,r1                     release message
          blwp      BREL$
          mov       r7,r0
          ai        r0,chobusy                signal more output space
          blwp      V$
          jmp       jlb01A                      -> drop next output msg
          
jlb01C    mov       r7,r0                     DROP PENDING INPUT LINE MSGS
          ai        r0,chiavail
          blwp      PMAY$                     more lines to drop?             
          jeq       jlb01D                      -> no

          mov       r7,r9                     remove message from input queue
          ai        r9,chimsgq
          blwp      REMOVE

          mov       mbtype(r8),r0             save message type
          mov       r8,r1                     release message
          blwp      BREL$
          ci        r0,mttext                 was it a text msg?                      
          jne       jlb01C                      -> no, drop next (if any)

          mov       r7,r0                     add one to free capacity
          ai        r0,chilim
          blwp      V$
          jmp       jlb01C                      -> drop next (if any)

jlb01D    bl        TRGINT                    BUILD INT MSG FOR INPUT QUEUE
          mov       r7,r9                     add int msg to input queue
          ai        r9,chimsgq
          blwp      PUSH$
          
          mov       r7,r0                     signal input available
          ai        r0,chiavail
          blwp      V$

          bl        TRGINT                    BUILD INT MSG FOR USER WORK QUEUE
          mov       chuser(r7),r9             add int msg to handler queue
          mov       r9,r0
          ai        r9,ushmq
          blwp      PUSH$

          ai        r0,ushwork                signal work available
          blwp      V$

          movb      lbl004,r0                 ECHO "^C" TO TERMINAL
          bl        echo                      echo caret
          li        r0,04300
          bl        echo                      echo "C"
          b         lbl016                      -> next character

.
. Process input char in raw mode
.
lbl003    limi      0
          mov       r7,r1                     CAN CHAR BE ADDED TO LATEST MSG?
          ai        r1,chimsgq                check input msg queue head
          mov       qhl(r1),r2
          c         r1,r2                     input msg queue empty?
          jeq       jlb01E                      -> yes, allocate new message
          mov       mbtype(r2),r3
          ci        r3,mttext                 previous msg is mttext?
          jne       jlb01E                      -> no, allocate new message
          mov       mbrpl(r2),r3              previous mgs has extra space?
          jeq       jlb01E                      -> no, allocate new message
          mov       mblen(r2),r3              [?? next lines are a bug?]
          ci        r3,20                     previous msg has >20 characters?
          jhe       jlb01E                      -> yes, allocate new message

          inc       mblen(r2)                 ADD CHAR TO PREVIOUS INPUT MSG
          a         r3,r2
          movb      r0,mbtext(r2)             add char
          limi      15
          b         rdloop                      -> process next

jlb01E    limi      15

          mov       r0,r1                     CHECK PENDING LINE MSG COUNT
          mov       r7,r0
          ai        r0,chilim
          blwp      PMAY$                     line msg available?
          jeq       jlb01F                      -> no, ignore + sound bell
          mov       r1,r0

          mov       chibip(r7),r1             ALLOCATE NEW TEXT BLOCK
          s         chibuf(r7),r1             calculate current input buf len
          mov       r1,r2
          ai        r1,mbtext+20              add hdr len + 20 bytes extra
          blwp      BGETA$                    allocate block
          data      rdloop                      -> on error, drop char & cont.
          li        r3,mttext
          mov       r3,mbtype(r1)             set type to text
          seto      mbrpl(r1)                 signal presence of 20 extra bytes
          mov       r2,mblen(r1)              set length
          inc       mblen(r1)                   including current char

          mov       r1,r8                     copy the current input buffer
          ai        r1,mbtext
          mov       chibuf(r7),r3
jlb021    dec       r2
          jlt       jlb020  
          movb      *r3+,*r1+
          jmp       jlb021
          
jlb020    movb      r0,*r1+                   add the new character

          mov       r7,r9                     ADD TO INPUT MESSAGE QUEUE
          ai        r9,chimsgq
          blwp      INSERT

          mov       r7,r0                     SIGNAL INPUT AVAILABLE
          ai        r0,chiavail
          blwp      V$

          mov       chibuf(r7),chibip(r7)     reset input buffer
          clr       chechol(r7)               clear echo lock
          b         rdloop                      -> process next
.
. sound bell
.
jlb01F    movb      lbl009,r0                 load <BEL>
          bl        echo                      echo
          b         rdloop                      -> read next
.
. check if char is in A-Za-z0-9$ set
.
iswdch    cb        r0,lbl00F                 char is '$'?
          jeq       jlb022                      -> in range
          cb        r0,lbl017                 char < '0' ?
          jl        jlb023                      -> out of range
          cb        r0,lbl017+1               char <= '9'?
          jle       jlb022                      -> in range
          cb        r0,lbl018                 char < 'A'?
          jl        jlb023                      -> out of range
          cb        r0,lbl018+1               char <= 'Z'?
          jle       jlb022                      -> in range
          cb        r0,lbl019                 char < 'a'?
          jl        jlb023                      -> out of range
          cb        r0,lbl019+1               char <= 'z'?
          jle       jlb022                      -> in range

jlb023    b         2(r11)                    return for out of range

jlb022    mov       *r11,r11                  return for in range
          rt
.
.
.
rubout    mov       r11,r6                    RUBOUT ONE CHARACTER
          dec       chibip(r7)                backup input ptr
          mov       chibip(r7),r1
          movb      *r1,r2                    get deleted character
          li        r0,00820                  erase equence <BS><SP>
          li        r4,1                      rub out count one
          cb        r2,lbl004+1               was it a control character?
          jhe       jlb024                      -> no
          inc       r4                        yes, rub out count two (del "^")
jlb024    bl        echo                      echo <BS>
          swpb      r0
          bl        echo                      echo space  
          swpb      r0
          bl        echo                      echo <BS>
          dec       r4
          jne       jlb024  
          mov       r7,r0                     signal output work available
          ai        r0,chowork
          blwp      V$
          b         *r6
.
.
.
prompt    mov       r11,r6                    RETYPE PROMPT
          mov       chprompt(r7),r3           any prompt saved?
          jeq       jlb025                      -> no
          mov       mblen(r3),r4              re-prompt and signal output work
          mov       mbtype(r3),r3
jlb026    dec       r4
          jlt       jlb025  
          movb      *r3+,r0
          bl        echo  
          mov       r7,r0                     signal output char available
          ai        r0,chowork
          blwp      V$
          jmp       jlb026
jlb025    b         *r6
.
.
.
echo      mov       r0,r2                     ECHO A CHARACTER
          mov       r7,r0
          ai        r0,choechl                wait for space in the echo queue
          blwp      P$
          mov       r2,r0
          mov       chechip(r7),r2            get echo insertion ptr
          movb      r0,*r2+                   pur char on echo list
          c         r2,chechbe(r7)            at end of echo buffer?
          jl        jlb027                      -> no
          mov       chechb(r7),r2             put insertion ptr back to start
jlb027    mov       r2,chechip(r7)
          rt        
.
.
TRGINT*   li        r1,mbtext                 BUILD AN INTERUPT MESSAGE
          blwp      BGETA$                    allocate buffer
          data      MEMFUL  
          mov       r1,r8                     set type to 'int'
          li        r0,mtint
          mov       r0,mbtype(r8)
          rt 
.
. output loop
.
wrloop    mov       r7,r0                     WAIT FOR ANY OUTPUT WORK
          ai        r0,chowork                could be echo or user output
          blwp      P$

jlb02A    c         chechip(r7),chechrp(r7)   MORE TEXT TO ECHO?
          jeq       jlb028                      -> no, try user output
          mov       chechrp(r7),chobuf(r7)    set cur output ptr to echo buf
          mov       one,chocount(r7)          output one char
          mov       chdrvv(r7),r5             find dev. driver
          mov       cvopout(r5),r1            find output routine
          bl        *r1                       send echo text to driver
          
          mov       r7,r0                     wait for character to be sent
          ai        r0,chowait
          blwp      P$

          mov       chechrp(r7),r1            MOVE ECHO REMOVAL PTR FORWARD
          inc       r1
          c         r1,chechbe(r7)            past end?
          jl        jlb029                      -> no
          mov       chechb(r7),r1             wrap around to start
jlb029    mov       r1,chechrp(r7)

          mov       r7,r0                     RETURN SPACE TO ECHO QUEUE
          ai        r0,choechl
          blwp      V$
          jmp       jlb02A                      -> process next echo char

jlb028    mov       chechol(r7),r0            OUTPUT LOCKED TO ECHO ONLY?
          jne       wrloop                         -> yes, wait for more

          mov       r7,r9                     FETCH NEXT USER OUTPUT MESSAGE
          ai        r9,chomsgq                get msg from user output queue
          blwp      REMOVE
          c         r8,r9                     queue was empty?
          jeq       wrloop                         -> yes, wait for more

          mov       r8,chomsgb(r7)            keep reference to cur output msg
          mov       chprompt(r7),r1           was a prompt saved?
          jeq       jlb02B                      -> no
          clr       chprompt(r7)              clear reference and
          blwp      BREL$                     release prompt msg

jlb02B    mov       mblen(r8),r0              
          mov       r8,r1
          ai        r1,mbtext

jlb02E    clr       r2                        FIND OUTPUT UP TO NEXT <CR>
          mov       r1,chobuf(r7)             start ptr for driver
jlb02D    dec       r0                        more output to scan?
          jlt       jlb02C                      -> no
          inc       r2                        increase length
          cb        *r1+,lbl005+1             output char is <CR>?
          jne       jlb02D                      -> no, scan further

          mov       r2,chocount(r7)           SEND UP TO <CR> TO DRIVER
          mov       r1,chosvad(r7)            save output address
          mov       r0,chosvln(r7)            save output length
          mov       chdrvv(r7),r5             - get driver vector
          mov       cvopout(r5),r1            - get driver output routine
          bl        *r1                       call driver
          mov       r7,r0
          ai        r0,chowait
          blwp      P$                        wait for driver interrupt

          li        r0,lbl00A                 SEND <LF> TO DRIVER
          mov       r0,chobuf(r7)             set address of <LF> byte
          li        r0,1
          mov       r0,chocount(r7)           set length one
jlb030    mov       chdrvv(r7),r5             - get driver vector
          mov       cvopout(r5),r1            - get driver output routine
          bl        *r1                       call driver
          mov       r7,r0
          ai        r0,chowait
          blwp      P$                        wait for driver interrupt

          mov       chosvad(r7),r1            restore r0, r1
          mov       chosvln(r7),r0
          jmp       jlb02E                      -> print up to next <CR>

jlb02C    mov       r2,chocount(r7)           any output left past last <CR>?
          jeq       jlb02F                      -> no
          mov       chomsgb(r7),r1            
          mov       r2,mblen(r1)
          mov       chobuf(r7),mbtype(r1)     
          mov       r1,chprompt(r7)           SET PROMPT TO OUTPUT TAIL
          clr       chomsgb(r7)
          clr       chosvln(r7)
          jmp       jlb030                    and output prompt / tail

jlb02F    mov       chomsgb(r7),r1            CLEAR SAVED PENDING OUTP. MESSAGE
          jeq       jlb031                      -> nothing saved
          clr       chomsgb(r7)               clear reference and
          blwp      BREL$                     release message

jlb031    mov       r7,r0                     ADD BACK TO OUTPUT SPACE
          ai        r0,chobusy
          blwp      V$
          b         jlb02A                      -> process more output
.
. TRMQMS: queue a message on the user output queue
.  input: r0 = terminal block ptr
.
TRMQMS*   mov       r0,r9                     ADD OUTPUT MSG TO TERM. QUEUE
          ai        r0,chobusy                wait for output queue free space
          blwp      P$

          ai        r9,chimsgq                CHECK FOR PENDING ^C INTERRUPT       
          mov       qfl(r9),r0                fetch head of input queue
          c         r0,r9                     input queue empty?
          jeq       jlb032                      -> yes, accept output
          ai        r0,mbtype                 get top input message type
          mov       *r0,r0
          ci        r0,mtint                  ^C interrupt pending?
          jeq       jlb033                      -> drop output request

jlb032    mov       r9,r0                     ACCEPT OUTPUT
          ai        r9,chomsgq-chimsgq        place msg on output queue
          blwp      INSERT
          ai        r0,chowork-chimsgq        signal work available
          blwp      V$
          rt

jlb033    mov       r1,r0                     DROP OUTPUT
          mov       r8,r1                     release msg
          blwp      BREL$
          mov       r0,r1                     [?? was saving r1 needed?]

          mov       r9,r0
          ai        r0,chobusy-chimsgq        add reserved space back to
          blwp      V$                          output queue free space
          rt        
.
. Get input line. Prompt for it as needed
.   input: r0 = term ptr; prompt msg already posted
.
TRIGET*   mov       r0,r9                     IS AN INPUT LINE PENDING?
          ai        r0,chiavail
          blwp      PMAY$                     test but do not yield
          jeq       jlb034                      -> no line pending

jlb036    ai        r9,chimsgq                FETCH INPUT LINE
          blwp      REMOVE
          mov       mbtype(r8),r9
          ci        r9,mttext                 is it a regular text message?
          jne       jlb035                      -> no, must be an interupt
          ai        r0,chilim-chiavail        signal input limit queue
          blwp      V$
jlb035    rt

jlb034    seto      chinwtg(r9)               set input wanted flag
          ai        r0,chowork-chiavail       signal output available (the prompt)
          blwp      V$
          ai        r0,chiavail-chowork       yield-wait for input available
          blwp      P$
          clr       chinwtg(r9)               clear input wanted flag
          jmp       jlb036  
.
.
one       data      1
lbl005    data      0080d                     <bs> <cr>
lbl00A    data      00a03                     <lf> <etx>
lbl009    data      00712                     <bel><dc2>
lbl008    data      01317                     <dc3><etb>
lbl007    data      0181b                     <can><esc>
.
lbl017    text      "09"
lbl018    text      "AZ"
lbl019    text      "az"
lbl00F    text      "$@"
lbl004    text      "^ "
          even
.
          end        
.
