.
. Reconstructed source code of NOS/MT
.
.   Original code by John Walker / Dan Drake, ca. 1980
.   Disassembly tool by Peter Buro, 1986
.
          idt       "BOOT"
.
          copy      "../systemdef/sysdef"
          copy      "../systemdef/specialdef"
.
. Main system initalisation routine, called from RTSCHED.ASM
.
sinit*    li        r1,JSREGS           SAVE RETURN ADDR. IN TEMP PLACE
          mov       r11,2*r3(r1)        [?? why not simply in a global var?]
.
.                                       SET UP BRANCH TABLE IN LOW MEM
          li        r1,table            point to edit etc branch table
          li        r2,00080            start address
          li        r0,tbllen           length of table
tblspin   mov       *r1+,*r2+           put table at start of memory
          dec       r0                  any more?
          jne       tblspin             yes then once more
.
.                                       SET UP XOP 1 (JSYS) VECTOR 
          li        r0,jsregs           jsys workspace
          mov       r0,00044            xop 1 wp
          li        r0,jsys             jsys
          mov       r0,00046            xop 1 pc
.
.                                       SET UP USER PROCESS LIST
          li        r9,uprocl           user process list head
          blwp      initq$
          li        r8,uph              users*processperuser*length
upspin    blwp      insert
          ai        r8,phul             length of user process header
          ci        r8,uphe             reached end 
          jl        upspin              no, then do another
.
.                                       SET UP USER CONTROL BLOCKS
          li        r1,mbit             memory bank pointers
          li        r2,ucts             user control tables
          li        r3,trit             terminal pointers
mtspin    mov       *r1+,r4             membank
          mov       *r3+,r5             terminal
          mov       r4,usmb(r2)         user memory bank
          mov       r5,usterm(r2)       user terminal
          mov       r2,chuser(r5)       user control table -> terminal
          ai        r2,usl              len of user control table + file table
          ci        r2,ucte             reached end 
          jl        mtspin              no, then do another set
.
.                                       SET UP USER HANDLER PROCESSES
          li        r1,ucts             user control tables
          li        r8,usph             user system process headers
          li        r9,readyq
          ai        r9,00008            ready queue for priority 5?

rqspin    mov       r1,phregs+2*r7(r8)  handler r7 = ptr to user control block
          mov       r8,r0
          ai        r0,phregs           register start
          mov       r0,phws(r8)         set up handler WP
          li        r0,userh            start of user handler
          mov       r0,phpc(r8)         set up handler initial PC
          li        r0,0000F            status 
          mov       r0,phstat(r8)       set up handler initial status
          li        r0,pruserh
          mov       r0,phprior(r8)      set user handler priority
          blwp      insert
          
          ai        r8,phls             move to next user / handler process
          ai        r1,usl              user control table length
          ci        r1,ucte             reached the end?
          jl        rqspin                -> no, do next one
.
.                                       SET UP THE TERMINAL HANDLERS
          li        r0,tritl            # of terminal pointers
          li        r1,trit             start of table
tbspin    li        r2,JSREGS
          mov       *r1+,r7             get terminal pointer
          mov       r0,*r2+             save #
          mov       r1,*r2              save pointer to next
          bl        TRBOOT              start terminal processes
          li        r2,JSREGS
          mov       *r2+,r0             get #
          mov       *r2,r1              get pointer
          dec       r0                  any more to do
          jne       tbspin              yes do another
.
.                                       SET UP SPECIAL DEVICES
          li        r1,spnt             special name table
spnspin   mov       spnfct(r1),r6       file control table
          mov       spnvec(r1),r2       driver acces vector
          mov       spvboot(r2),r2      boot init
          jeq       nospnboot           nothing to do, then skip it
          mov       r1,JSREGS           save spn pointer
          bl        *r2                 go and do boot routine
          mov       JSREGS,r1           get spn pointer
nospnboot ai        r1,spnl             length of name table entry
          ci        r1,spnte            reached the end?
          jhe       spnend                -> yes, done with special devices

          mov       -6(r1),r11          file index of previous
          ci        r11,00080
          jl        spnspin 
          c         r11,spnidx(r1)
          jh        spnspin
spnend    
.
.                                       SET UP SYSTEM CLOCKS
          li        r7,rtct             real time clock
          mov       rcdrvv(r7),r1       driver entry vector address
          mov       rtvboot(r1),r1      boot time init
          bl        *r1                 go and boot it
          mov       YRCLK,r7            do we have a year clock?
          jeq       noyear              no, then skip this nonsense
          mov       00002(r7),r1        fetch year clock time
          mov       *r1,r1
          bl        *r1
          li        r2,UCLOCK           set system clock to year clock
          mov       r0,*r2+
          mov       r1,*r2
noyear    
.
.                                       SET UP STORAGE UNITS
          li        r0,SUITL            # of storage unit pointers
          li        r1,SUIT             point to table

suspin    mov       *r1+,r2             get a storage unit
          li        r3,JSREGS
          mov       r0,*r3+             save #
          mov       r1,*r3              save pointer to next

          clr       surefc(r2)          INIT CTRL BLOCK, ref count = 0
          clr       sustat(r2)          set status = not mounted
          mov       r2,r9
          ai        r9,surplm           init reply message queue
          blwp      initq$
          ai        r9,surpld-surplm    init reply message P/V queue
          blwp      initq$
          clr       qn(r9)              clear queue count

          mov       suhiou(r2),r3       RUN DEVICE INIT ROUTINE
          ci        r3,1                is it the first on driver?
          jne       notfsu                -> no, skip boot part
          mov       suhior(r2),r3       driver entry vector
          mov       suhiop(r2),r7       driver control table
          mov       bvboot(r3),r4       boot time init
          bl        *r4                 go and do boot init

notfsu    li        r3,JSREGS           MORE UNITS TO DO?
          mov       *r3+,r0             get #
          mov       *r3,r1              get pointer
          dec       r0                  any more SU to init?
          jne       suspin                -> yes, go and do another
.
.                                       INIT FILE SYSTEM PROCESS
          li        r9,FSMSGQ           FS message queue
          blwp      INITQ$
          li        r9,FSWORK           FS work available semaphore
          blwp      INITQ$
          clr       qn(r9)              start with empty queue
          
          li        r8,FSPH             SET UP PROCESS BLOCK FOR FS
          li        r9,READYQ
          ai        r9,00008            add to ready queue for prio 5 ??
          mov       r8,r0               r8 = ptr to process block
          ai        r0,phregs           r0 = start of default workspace
          mov       r0,phws(r8)         set initial WP
          li        r0,FSINIT
          mov       r0,phpc(r8)         set initial PC to FSINIT routine
          li        r0,0000F            
          mov       r0,phstat(r8)       set initial status to 000F
          li        r0,prfsys
          mov       r0,phprior(r8)      set process priority
          blwp      INSERT

.                                       SET UP THE AUTO SYNC PROCESS
          li        r0,SYNCTM           config for clock ticks / auto sync?
          jeq       nosync              none, then skip this
          li        r0,SYNCIN           initial process PC
          clr       r1                  no local storage
          li        r2,pruserh          run with user handler priority
          blwp      FORK$                 -> fork process (never returns?)

.                                       RETURN TO MAIN INIT ROUTINE
nosync    li        r1,JSREGS           get return addr back from save place
          mov       2*r3(r1),r11
          rt
.
.
memful*   blwp      SNAP$
          text      "*Ran out of buffers!  Make BSIZE larger and regenerate!&"
          even
          lrex      
.
table     b         BGET
          b         BGETA
          b         BREL
          b         EDIT$
          b         EDITX$
          b         EDITR$
          b         ECHAR$
          b         ESKIP$
          b         ECOL$
          b         ECOLN$
          b         ECOPY$
          b         EMSG$
          bss       16 
          b         EMSGR$
          b         EMSG1$
          b         EHEXF$
          b         EHEXV$
          b         EDECF$
          b         EDECV$
          b         INSRT
          b         PUSH
          b         REMOV
          b         INITQ
          b         BEXP
.
tbllen    equ       ($-table)/2
.
          end        
.
