#include "param.h"
#include "systm.h"
#include "buf.h"
#include "conf.h"

/*
 * In case console is off,
 * panicstr contains argument to last call to panic.
 */
char	*panicstr;
int	ka6,ka7;		/* values of fp and sp */

/*
 * Scaled down version of C Library printf.
 * Only %s %u %d (==%u) %o %x %D are recognized.
 * Used to print diagnostic information
 * directly on console tty.
 * Since it is not interrupt driven,
 * all system activities are pretty much suspended.
 * Printf should not be used for chit-chat.
 */
printf(fmt, x1)
register char *fmt;
unsigned x1;
{
	register c;
	register unsigned int *adx;
	char *s;

	adx = &x1;
loop:
	while((c = *fmt++) != '%') {
		if(c == '\0')
			return;
		putchar(c);
	}
	c = *fmt++;
	if(c == 'd' || c == 'u' || c == 'o' || c == 'x')
		printn((long)*adx, c=='o'? 8: (c=='x'? 16:10));
	else if(c == 's') {
		s = (char *)*adx;
		while(c = *s++)
			putchar(c);
	} else if (c == 'D') {
		printn(*(long *)adx, 10);
		adx += (sizeof(long) / sizeof(int)) - 1;
	}
	adx++;
	goto loop;
}

printn(n, b)
long n;
register b;
{
	register i, nd, c;
	int	flag;
	int	plmax;
	char d[12];

	c = 1;
	flag = n < 0;
	if (flag)
		n = (-n);
	if (b==8)
		plmax = 11;
	else if (b==10)
		plmax = 10;
	else if (b==16)
		plmax = 8;
	if (flag && b==10) {
		flag = 0;
		putchar('-');
	}
	for (i=0;i<plmax;i++) {
		nd = n%b;
		if (flag) {
			nd = (b - 1) - nd + c;
			if (nd >= b) {
				nd -= b;
				c = 1;
			} else
				c = 0;
		}
		d[i] = nd;
		n = n/b;
		if ((n==0) && (flag==0))
			break;
	}
	if (i==plmax)
		i--;
	for (;i>=0;i--) {
		putchar("0123456789abcdef"[d[i]]);
	}
}

/*
 * Panic is called on unresolvable fatal errors.
 * It syncs, prints "panic: mesg" and then loops.
 */
panic(s)
char *s;
{
	struct buf *discwork;

	if (s && panicstr)
		printf("Double panic: %s\n", s);
	else {
		if (s)
			panicstr = s;
		printf("panic: %s\n", panicstr);
		update();
		discwork = bdevsw[major(rootdev)].d_tab;
		printf("Syncing discs... ");
		while (discwork->av_forw)
			;
		printf("Done\n");
		
	}
	asm("movl	a6, _ka6");
	asm("movl	sp, _ka7");
	dumpsys();
	splhigh();
	for(;;)		/* dog will starve here */
		;
}


/*
 * prdev prints a warning message.
 * dev is a block special device argument.
 */
prdev(str, dev)
char *str;
dev_t dev;
{
	printf("%s on dev %u/%u\n", str, major(dev), minor(dev));
}

/*
 * prcom prints a diagnostic from a device driver.
 * prt is device dependent print routine.
 */
prcom(prt, bp, er1, er2)
int (*prt)();
register struct buf *bp;
{
	prdev("err", bp->b_dev);
	printf("bn = %D er = %o,%o\n", bp->b_blkno, er1, er2);
}
