/* lrld.c:  lan redundancy line discipline */
/*	also contains lr.cs and lr.events */
#include "param.h"
#include "types.h"
#include "ethernet.h"
#include "errno.h"
#include "signal.h"
#include "stream.h"
#include "dir.h"
#include "seg.h"
#include "ipm.h"
#include "user.h"
#include "buf.h"

#define	LR_STATUS	0
#define	LR_CHANGE	1

#define	T1	15			/* broadcast time in Hz */
#define	T2	(5*60*4)		/* auto switch time in T1 */
#define	T3	5			/* switch rate too high */
#define	LT(a, b)	((int)((a)-(b)) < 0)
#define	GE(a, b)	((int)((a)-(b)) >= 0)

struct	lrmsg {
	unsigned char dhost[ETHERALEN];
	unsigned char shost[ETHERALEN];
	unsigned short e_type;
	unsigned short	type;		/* message type */
	unsigned short	this_lan;
	unsigned short 	active_lan;
};

int	active_lan;
struct	queue *lan_a_q, *lan_b_q;	/* pointers to network interfaces */
int	timer_running;
u_long	lr_clock;			/* 250ms clicks */
u_long	st;				/* T1s since last switch */
u_long	pst;				/* previous value of st */
int	ignore;				/* don't beleive switch requests */
extern	activenc;

int	lrqopen(), lrqclose(), lruputq();
int	srv(), putq(), nullsys();

struct	qinit lrldqinit[] = {
/*up*/ { lruputq, srv, nullsys, nullsys, 20, 5 },
/*dn*/ { putq, srv, lrqopen, lrqclose, 20, 5 }
};

lrqopen(dev, q)
	dev_t dev;
	struct queue *q;
{
	int lrtimer();

	if (lan_a_q == NULL)
		lan_a_q = q;
	else if (lan_b_q == NULL)
		lan_b_q == q;
	else
		return ENXIO;
	if (! timer_running) {
		timeout(lrtimer, 0, T1);
		timer_running++;
	}
	return 0;
}

lrqclose(dev, q)
	dev_t dev;
	struct queue *q;
{
	if (lan_a_q == q)
		lan_a_q = NULL;
	else if (lan_b_q == q)
		lan_b_q == NULL;
	return 0;
}




lruputq(q, bp)	/* process incoming message */
	register struct queue *q;
	register struct block *bp;
{
	register struct lrmsg *lp;

	if (bp->wptr - bp->rptr < sizeof (struct lrmsg)) {
		freeb(bp);
		return;
	}
	lp = (struct lrmsg *)(bp->rptr);
	if (lp->type != 0 && lp->type != 1) {
		freeb(bp);
		return;
	}
	if (!activenc) {
		if (lp->type == LR_STATUS)
			active_lan = lp->active_lan;
		freeb(bp);
		return;
	} /* else active */
	if (ignore || lp->type == LR_STATUS) {
		freeb(bp);
		return;
	}
	if (lp->type != LR_STATUS) {
		printf("lrld: bad lrmsg type (0x%x)\n", lp->type);
		freeb(bp);
		return;
	}
	lr_switch(lp->active_lan);
	if (LT(lr_clock - pst, T3))
		ignore++;
	freeb(bp);
}

lrtimer()		/* 250ms tick */
{
	static int active;	/* note changes up stream */
	register struct queue *q;

	timeout(lrtimer, 0, T1);
	lr_clock++;
	if (!activenc)
		return;
	if (GE(lr_clock - st, T2)) {
		ignore = 0;
		lr_switch(active_lan ^ 1);
		return;
	}
	lr_gping();
}


lr_gping()	/* global ping */
{
	if (lan_a_q)
		lr_ping(lan_a_q, 0, active_lan);
	if (lan_b_q)
		lr_ping(lan_b_q, 1, active_lan);
}


lr_switch(lan)		/* switch to `lan' */
{
	if (lan == active_lan)
		return;
	active_lan = lan;
	pst = st;
	st = lr_clock;
	lr_gping();
	lr_event();
}

lr_ping(q, this, active)
	register struct queue *q;
	register this, active;
{
	register struct block *bp;
	register struct lrmsg *lrp;

	bp = allocb(sizeof (struct lrmsg));
	bp->wptr += sizeof (struct lrmsg);
	lrp = (struct lrmsg *)bp->rptr;
	setaddr(lrp->dhost, 0xff, ETHERALEN);
	lrp->e_type = 0xbad2;
	lrp->type = LR_STATUS;
	lrp->this_lan = this;
	lrp->active_lan = active;
	(*q->qinfo->putp)(q, bp);
}

/* The lr.cs device */

static	char	rdstr[2];

lrread(dev)
	dev_t dev;
{
	register n;

	rdstr[0] = 'a' + (active_lan & 1);
	rdstr[1] = '\n';
	n = min(u.u_count, sizeof rdstr - u.u_offset);
	if (n <= 0)
		return;
	iomove(&rdstr[u.u_offset], n, B_READ);
}

lrwrite(dev)
	dev_t dev;
{
	register c, f;

	while ((c = cpass()) != -1) {
		f = (c == 'a') ? 0 : (c == 'b') ? 1 : -1;
		if (f == -1)
			continue;
		lr_switch(f);
	}
}

/* The lr.events driver */

int	putq(), srv(), lreqopen(), nullsys(), lreqclose();
struct	qinit	lrqinit[] = {
/*up*/	{ putq, srv, lreqopen, lreqclose, 10, 2 },
/*dn*/	{ putq, srv, nullsys, nullsys, 10, 2 }
};

struct	queue	*lr_events_q;

lreqopen(dev, q)
	dev_t dev;
	struct queue *q;
{
	lr_events_q = q;
}

lreqclose(dev, q)
	dev_t dev;
	struct queue *q;
{
	lr_events_q = NULL;
}

lr_event()		/* send event up device */
{
	register struct block *bp;

	if (lr_events_q == NULL)
		return;
	bp = allocb(1);
	*bp->wptr++ = 'a' + (active_lan & 1);
	(lr_events_q->qinfo->putp)(lr_events_q, bp);
}
static
setaddr(p, c, n)	/* set 'n' bytes from 'p' to be 'c' */
	register char *p;
	register char c;
	register n;
{
	while (n--)
		*p++ = c;
}
