/* machdep.c:  Machine-dependent startup code. */

#include "param.h"
#include "systm.h"
#include "dir.h"
#include "signal.h"
#include "seg.h"
#include "ipm.h"
#include "sid.h"
#include "user.h"
#include "errno.h"
#include "proc.h"
#include "map.h"
#include "reg.h"
#include "types.h"


/*
 * 	Icode is the hex bootstrap
 *	program executed in user mode
 *	to bring up the system.
 */

short	icode[] = {
/*00*/	0x2e7c, 0x0000, 0x001e,		/* movl		#0x1e,sp */
/*06*/	0x700b,				/* movel	#11,d0 */
/*08*/	0x4e40,				/* trap		#0 */
/*0a*/	0x60fe,				/* bra		. */
/*0c*/	0x0000, 0x0014,
/*10*/	0x0000, 0x0000,
/*14*/	0x2f65, 0x7463, 0x2f69, 0x6e69, 0x7400,
					/* .asciz	"/etc/init" */
/*1e*/	0x0000, 0x0000,
/*22*/	0x0000, 0x0014,
/*26*/	0x0000, 0x000c,
/*2a*/	0x0000, 0x002a,
/*2e*/	0x4e71
};
long	szicode = sizeof(icode);

char	copyright[] = 
  "Copyright (C) 1991 Adaptive Corporation, All Rights Reserved";

/*
 * Machine-dependent startup code
 */
startup()
{
	extern long locore;
	register a, i;

	pccinit();
	ziinit();
	printf("GunOS - Adaptive Generic Unix\n");
	i = btoc(locore) + USIZE;
	while (fubyte(ctob(i)) != -1) {
		clearseg(i);
		maxmem++;
		mfree(coremap, 1, i);
		i++;
	}
	printf("mem = %d\n", ctob(maxmem));
	mfree(swapmap, nswap, 1);
	swplo--;
}

timepoke()	/* don't know what this does.  It may be leftover from VAX */
{
}


/*
 * Send an interrupt to process
 */

sendsig(hdlr, signo)
{
	register *usp, *regs;

	regs = u.u_ar0;
	usp = (int *)regs[SP];
	if (u.u_traptype) {
		regs[PC] |= 1;	/* make odd to prevent sucessful 'rtr' */
		u.u_trapvalid = u.u_trapsave[0];
		u.u_trapsave[0] = 0;
	}
	grow((unsigned)(usp-16));
	/* simulate an interrupt on the user's stack */
	suword((caddr_t)--usp, regs[PC]);
	suword((caddr_t)--usp, regs[PS]);
	suword((caddr_t)--usp, 0);	/* junk to keep signal.s happy */
	suword((caddr_t)--usp, signo);
	regs[SP] = (int)usp;
	regs[PC] = (int)hdlr;

}

/*
 * print hex dump of something 
 */

dump(cp, n)
	register char *cp;
	register n;
{
	printf("0x%x: ", cp);
	while (n--) {
		printf("0x%x ", *cp++ & 0xff);
		if ((n&0xf) == 0)
			printf("\n0x%x:	", cp);
	}
}



/*
 * Mk48T02 timekeeper ram code
 * Some of the code here is stolen from the date command and friends
 */



#define bcd_to_d(n)   ((char)(n&017) + ((n>>4)&017)*10)
#define d_to_bcd(n)   ((char)(n/10)<<4 | (n%10))

#define	CBYTE	((u_char *) 0xfffe07f8)
#define	SEC	((u_char *) CBYTE+1)
#define	MIN	((u_char *) CBYTE+2)
#define	HOUR	((u_char *) CBYTE+3)
#define	DAY	((u_char *) CBYTE+4)
#define	DATE	((u_char *) CBYTE+5)
#define	MONTH	((u_char *) CBYTE+6)
#define	YEAR	((u_char *) CBYTE+7)

#define	WRITE	0x80   /* for |'ing */
#define	READ	0x40   /* for |'ing */
#define	STOP	0x80   /* for |'ing */
#define KS	0x80
#define	NORM	0x3f   /* for & masking*/


static	int	dmsize[12] =
{
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 
};
extern time_t lbolt;


rtcset(tim)  /* set rtc to GMT matching tim */
register time_t	tim;
{
	register int d1;
	register long day;
	long hms;

	/*
	 * break initial number into days
	 */
	hms = tim % 86400;
	day = tim / 86400;
	if (hms<0) {
		hms += 86400;
		day -= 1;
	}

	/*
	 * generate hours:minutes:seconds
	 */
	*CBYTE |= WRITE;
	*SEC = d_to_bcd((hms%60));
	d1 = hms/60;
	*MIN = d_to_bcd((d1%60));
	d1 /= 60;
	*HOUR = d_to_bcd(d1);

	/*
	 * day is the day number.
	 * generate day of the week.
	 * The addend is 4 mod 7 (1/1/1970 was Thursday)
	 */

	*DAY = d_to_bcd(((day+7340036)%7 + 1));

	/*
	 * year number
	 */
	if (day>=0) 
		for(d1=70; day >= dysize(d1); d1++)
			day -= dysize(d1);
	else for (d1=70; day<0; d1--)
		day += dysize(d1-1);
	*YEAR = d_to_bcd(d1);

	/*
	 * generate month
	 */

	if (dysize(d1)==366)
		dmsize[1] = 29;
	for(d1=0; day >= dmsize[d1]; d1++)
		day -= dmsize[d1];
	dmsize[1] = 28;
	*DATE = d_to_bcd((day+1));
	*MONTH = d_to_bcd((d1 + 1));
	*CBYTE &= NORM;
}


dysize(y) /* days in year */
register int y;
{
	if((y%4) == 0)
		return(366);
	return(365);
}



long
rtc_to_l()
{
	register long	timebuf;
	register int	year;
	register int 	i;
	int	 month, day, hour, min, sec;

	/* read time from chip */
	*CBYTE |= READ;
	year  = bcd_to_d(*YEAR);
	month = bcd_to_d(*MONTH);
	day   = bcd_to_d(*DATE);
	hour  = bcd_to_d(*HOUR);
	min   = bcd_to_d(*MIN);
	sec   = bcd_to_d(*SEC);
	*CBYTE &= NORM;

	timebuf = 0;
	year += 1900;
	for (i = 1970; i < year; i++)
		timebuf += dysize(i);
	/* leap year? */
	if (dysize(year) == 366 && month >= 3)
		timebuf++;
	while (--month)
		timebuf += dmsize[month - 1];
	timebuf += day-1;
	timebuf = 24*timebuf + hour;
	timebuf = 60*timebuf + min;
	timebuf = 60*timebuf + sec;
	return(timebuf);
}
	
	

rtcrun()  /* false if clock stopped */
{
	register int	running;

	*CBYTE |= READ;
	running = (! (*SEC & STOP));
	*CBYTE &= NORM;
	return(running);
}

rtcstart()  /* starts the RTC */
{
	register int	count;

	*CBYTE |= WRITE;
	*SEC &= ~STOP;    /* turn off stop bit */
	*HOUR |= KS;     /* set kick start bit */
	*CBYTE &= NORM;
	/* wait 2 seconds */
	for (count = 0; count <= 2; sleep((caddr_t) &lbolt), count++);
	*CBYTE |= WRITE;
	*HOUR &= ~KS;    /* turn off kick start bit */
	*CBYTE &= NORM;
}
	
	
#ifdef RTCDEBUG
rtcread()  /* print values of RTC; used for debugging */
{
	printf("\ncalibrate = 0%o\n", *CBYTE&077);
	printf("control   = 0%o\n", *CBYTE>>6&03);
	*CBYTE |= READ;
	printf("sec   = %x\n", *SEC);
	printf("min   = %x\n", *MIN);
	printf("hour  = %x\n", *HOUR);
	printf("day   = %x\n", *DAY);
	printf("date  = %x\n", *DATE);
	printf("month = %x\n", *MONTH);
	printf("year  = %x\n\n", *YEAR);
	*CBYTE &= NORM;
}

rtcstop()  /* stops the RTC */
{
	*CBYTE |= WRITE;
	*SEC |= STOP;
	*CBYTE &= NORM;
}
#endif
