/* vec.s:  Vector table */
	.text
	.globl	vec
	.align	1
vec:
	nop
	nop
	bra	_start
	.long	buserr		/* 8 */
	.long	nullvect	/* c */
	.long	nullvect	/* 10 */
	.long	nullvect	/* 14 */
	.long	nullvect	/* 18 */
	.long	nullvect	/* 1c */
	.long	nullvect	/* 20 */
	.long	nullvect	/* 24 */
	.long	nullvect	/* 28 */
	.long	nullvect	/* 2c */
	.long	nullvect	/* 30 */
	.long	nullvect	/* 34 */
	.long	nullvect	/* 38 */
	.long	nullvect	/* 3c */
	.long	nullvect	/* 40 */
	.long	nullvect	/* 44 */
	.long	nullvect	/* 48 */
	.long	nullvect	/* 4c */
	.long	nullvect	/* 50 */
	.long	nullvect	/* 54 */
	.long	nullvect	/* 58 */
	.long	nullvect	/* 5c */
	.long	nullvect	/* 60 */
	.long	nullvect	/* 64 */
	.long	nullvect	/* 68 */
	.long	nullvect	/* 6c */
	.long	nullvect	/* 70 */
	.long	nullvect	/* 74 */
	.long	nullvect	/* 78 */
	.long	nullvect	/* 7c */
	.long	nullvect	/* 80 */
	.long	nullvect	/* 84 */
	.long	nullvect	/* 88 */
	.long	nullvect	/* 8c */
	.long	nullvect	/* 90 */
	.long	nullvect	/* 94 */
	.long	nullvect	/* 98 */
	.long	nullvect	/* 9c */
	.long	nullvect	/* a0 */
	.long	nullvect	/* a4 */
	.long	nullvect	/* a8 */
	.long	nullvect	/* ac */
	.long	nullvect	/* b0 */
	.long	nullvect	/* b4 */
	.long	nullvect	/* b8 */
	.long	nullvect	/* bc */
	.long	nullvect	/* c0 */
	.long	nullvect	/* c4 */
	.long	nullvect	/* c8 */
	.long	nullvect	/* cc */
	.long	nullvect	/* d0 */
	.long	nullvect	/* d4 */
	.long	nullvect	/* d8 */
	.long	nullvect	/* dc */
	.long	nullvect	/* e0 */
	.long	nullvect	/* e4 */
	.long	nullvect	/* e8 */
	.long	nullvect	/* ec */
	.long	nullvect	/* f0 */
	.long	nullvect	/* f4 */
	.long	nullvect	/* f8 */
	.long	nullvect	/* fc */

/*	Begin Peripheral channel chip interrupt region */

	.long	pccacfailint	/* 100 */
	.long	pccberrint	/* 104 */
	.long	pccabortint	/* 108 */
	.long	pccserialint	/* 10c */
	.long	pcclanint	/* 110 */
	.long	pccscsiportint	/* 114 */
	.long	pccscsidmaint	/* 118 */
	.long	pccprinterint	/* 11c */
	.long	pcctick1int	/* 120 */
	.long	pcctick2int	/* 124 */
	.long	pccsi1int	/* 128 */
	.long	pccsi2int	/* 12c */

/* 	end of PCC interrupt region */

	.long	pimint		/* 130 */ /* begin pim */
	.long	pimint		/* 134 */
	.long	pimint		/* 138 */
	.long	nullvect	/* 13c */ /* end of pim */
	.long	nullvect	/* 140 */
	.long	nullvect	/* 144 */
	.long	nullvect	/* 148 */
	.long	nullvect	/* 14c */
	.long	nullvect	/* 150 */
	.long	nullvect	/* 154 */
	.long	nullvect	/* 158 */
	.long	nullvect	/* 15c */
	.long	nullvect	/* 160 */
	.long	nullvect	/* 164 */
	.long	nullvect	/* 168 */
	.long	nullvect	/* 16c */
	.long	nullvect	/* 170 */
	.long	nullvect	/* 174 */
	.long	nullvect	/* 178 */
	.long	nullvect	/* 17c */
	.long	nullvect	/* 180 */
	.long	nullvect	/* 184 */
	.long	nullvect	/* 188 */
	.long	nullvect	/* 18c */
	.long	nullvect	/* 190 */
	.long	nullvect	/* 194 */
	.long	nullvect	/* 198 */
	.long	nullvect	/* 19c */
	.long	nullvect	/* 1a0 */
	.long	nullvect	/* 1a4 */
	.long	nullvect	/* 1a8 */
	.long	nullvect	/* 1ac */
	.long	nullvect	/* 1b0 */
	.long	nullvect	/* 1b4 */
	.long	nullvect	/* 1b8 */
	.long	nullvect	/* 1bc */
	.long	nullvect	/* 1c0 */
	.long	nullvect	/* 1c4 */
	.long	nullvect	/* 1c8 */
	.long	nullvect	/* 1cc */
	.long	nullvect	/* 1d0 */
	.long	nullvect	/* 1d4 */
	.long	nullvect	/* 1d8 */
	.long	nullvect	/* 1dc */
	.long	nullvect	/* 1e0 */
	.long	nullvect	/* 1e4 */
	.long	nullvect	/* 1e8 */
	.long	nullvect	/* 1ec */
	.long	nullvect	/* 1f0 */
	.long	nullvect	/* 1f4 */
	.long	nullvect	/* 1f8 */
	.long	nullvect	/* 1fc */

/*	Start of zilog region */
/*	Channel B, chip 1 */

	.long	nullvect	/* 200 */
	.long	nullvect	/* 204 */
	.long	nullvect	/* 208 */
	.long	nullvect	/* 20c */
	.long	nullvect	/* 210 */
	.long	nullvect	/* 214 */
	.long	nullvect	/* 218 */
	.long	nullvect	/* 21c */

/*	Channel A, chip 1	*/

	.long	zixint		/* 220 */
	.long	nullvect	/* 224 */
	.long	zieint		/* 228 */
	.long	nullvect	/* 22c */
	.long	zirint		/* 230 */
	.long	nullvect	/* 234 */
	.long	zisrint		/* 238 */
	.long	nullvect	/* 23c */
	.long	nullvect	/* 240 */

/*	Channel B, chip 2  */

	.long	nullvect	/* 244 */
	.long	nullvect	/* 248 */
	.long	nullvect	/* 24c */
	.long	nullvect	/* 250 */
	.long	nullvect	/* 254 */
	.long	nullvect	/* 258 */
	.long	nullvect	/* 25c */
	.long	nullvect	/* 260 */

/*	Channel A, chip 2  */

	.long	nullvect	/* 264 */
	.long	nullvect	/* 268 */
	.long	nullvect	/* 26c */
	.long	nullvect	/* 270 */
	.long	nullvect	/* 274 */
	.long	nullvect	/* 278 */
	.long	nullvect	/* 27c */
	.long	nullvect	/* 280 */

/*	End of zilog region */

	.long	nullvect	/* 284 */
	.long	nullvect	/* 288 */
	.long	nullvect	/* 28c */
	.long	nullvect	/* 290 */
	.long	nullvect	/* 294 */
	.long	nullvect	/* 298 */
	.long	nullvect	/* 29c */
	.long	nullvect	/* 2a0 */
	.long	nullvect	/* 2a4 */
	.long	nullvect	/* 2a8 */
	.long	nullvect	/* 2ac */
	.long	nullvect	/* 2b0 */
	.long	nullvect	/* 2b4 */
	.long	nullvect	/* 2b8 */
	.long	nullvect	/* 2bc */
	.long	nullvect	/* 2c0 */
	.long	nullvect	/* 2c4 */
	.long	nullvect	/* 2c8 */
	.long	nullvect	/* 2cc */
	.long	nullvect	/* 2d0 */
	.long	nullvect	/* 2d4 */
	.long	nullvect	/* 2d8 */
	.long	nullvect	/* 2dc */
	.long	nullvect	/* 2e0 */
	.long	nullvect	/* 2e4 */
	.long	nullvect	/* 2e8 */
	.long	nullvect	/* 2ec */
	.long	nullvect	/* 2f0 */
	.long	nullvect	/* 2f4 */
	.long	nullvect	/* 2f8 */
	.long	nullvect	/* 2fc */
	.long	cmfifoint	/* 300 */
	.long	cmint		/* 304 */
	.long	cm2int		/* 308 */
	.long	nullvect	/* 30c */
	.long	nullvect	/* 310 */
	.long	nullvect	/* 314 */
	.long	nullvect	/* 318 */
	.long	nullvect	/* 31c */
	.long	nullvect	/* 320 */
	.long	nullvect	/* 324 */
	.long	nullvect	/* 328 */
	.long	nullvect	/* 32c */
	.long	nullvect	/* 330 */
	.long	nullvect	/* 334 */
	.long	nullvect	/* 338 */
	.long	nullvect	/* 33c */
	.long	nullvect	/* 340 */
	.long	nullvect	/* 344 */
	.long	nullvect	/* 348 */
	.long	nullvect	/* 34c */
	.long	nullvect	/* 350 */
	.long	nullvect	/* 354 */
	.long	nullvect	/* 358 */
	.long	nullvect	/* 35c */
	.long	nullvect	/* 360 */
	.long	nullvect	/* 364 */
	.long	nullvect	/* 368 */
	.long	nullvect	/* 36c */
	.long	nullvect	/* 370 */
	.long	nullvect	/* 374 */
	.long	nullvect	/* 378 */
	.long	nullvect	/* 37c */
	.long	nullvect	/* 380 */
	.long	nullvect	/* 384 */
	.long	nullvect	/* 388 */
	.long	nullvect	/* 38c */
	.long	nullvect	/* 390 */
	.long	nullvect	/* 394 */
	.long	nullvect	/* 398 */
	.long	nullvect	/* 39c */
	.long	nullvect	/* 3a0 */
	.long	nullvect	/* 3a4 */
	.long	nullvect	/* 3a8 */
	.long	nullvect	/* 3ac */
	.long	nullvect	/* 3b0 */
	.long	nullvect	/* 3b4 */
	.long	nullvect	/* 3b8 */
	.long	nullvect	/* 3bc */
	.long	nullvect	/* 3c0 */
	.long	nullvect	/* 3c4 */
	.long	nullvect	/* 3c8 */
	.long	nullvect	/* 3cc */
	.long	nullvect	/* 3d0 */
	.long	nullvect	/* 3d4 */
	.long	nullvect	/* 3d8 */
	.long	nullvect	/* 3dc */
	.long	nullvect	/* 3e0 */
	.long	nullvect	/* 3e4 */
	.long	nullvect	/* 3e8 */
	.long	nullvect	/* 3ec */
	.long	nullvect	/* 3f0 */
	.long	nullvect	/* 3f4 */
	.long	nullvect	/* 3f8 */
	.long	nullvect	/* 3fc */

root_ptr:
	.long	0x00ff0003		/* limit 256 long */
	.long	0x410			/* pointer to following segtable */

tc_proto:
	.long	0x80908f00		/* 512 pages, 8b seg, 15b page */
	.long	0			/*   the segtable aligned */


	.globl	_segtable
_segtable:
	.space	256 * 8
