/* udp_connect.c: get a socket, bind address and auto address packets */
#include <sys/inet/in.h>
#include <sys/inet/udp_user.h>

udp_connect(sport, dhost, dport)
	in_addr dhost;
	udp_port sport, dport;
{
	struct udpuser u;
	int fd;

	if ((fd = udp_sock()) == -1)
		return -1;
	u.laddr = INADDR_ANY;
	u.lport = sport;
	u.faddr = dhost;
	u.fport = dport;
	u.code = UDPC_CONNECT;
	if (write(fd, (char *)&u, sizeof u) == -1
	||  read(fd, (char *)&u, sizeof u) == -1
	||  u.code != UDPC_OK) {
		close(fd);
		return -1;
	}
	return fd;
}
