/* getcwd.c: posix get current working directory */
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <errno.h>

char *
getcwd(buf, size)
	char *buf;
	int size;
{
	FILE *p;
	extern int errno;
	char line[PATH_MAX];
	FILE *popen();

	if (size <= 0) {
		errno = EINVAL;
		return NULL;
	}
	if ((p = popen("/bin/pwd", "r")) == NULL) {
		errno = EACCES;
		return NULL;
	}
	if (fgets(line, sizeof line, p) == NULL) {
		errno = EACCES;
		pclose(p);
		return NULL;
	}
	line[strlen(line)-1] = '\0';	/* zap newline */
	pclose(p);
	if (strlen(line) > size) {
		errno = ERANGE;
		return NULL;
	}
	return strcpy(buf, line);
}
