/* udpconfig.c: activate udp datagram protocol */

#include <stdio.h>
#include <sys/inet/in.h>
#include <sys/filio.h>

main(argc, argv)
	int argc;
	char *argv[];
{
	int udp_fd, echo_fd;
	extern udp_ld;
	struct in_service *sp;
	int cnt;
	char buf[4096];

	/* do stuff to make a daemon */
	setpgrp(getpid(), getpid());
	if (argc != 2) {
		fprintf(stderr, "usage: %s udp-device\n", argv[0]);
		exit(1);
	}
	if ((udp_fd = open(argv[1], 2)) == -1) {
		perror(argv[1]);
		exit(1);
	}
	if (ioctl(udp_fd, FIOPUSHLD, &udp_ld) == -1) {
		perror("push udp_ld");
		exit(1);
	}
	sp = in_service("echo", "udp", 0);
	echo_fd = udp_datagram(sp->port);
	for (;;) {
		cnt = read(echo_fd, buf, sizeof buf);
		if (cnt > 0) {
			if (write(echo_fd, buf, cnt) < 0)
				perror("udpconfig: write");
		}
	}
}
