#include <sys/types.h>
#include <sys/signal.h>
#include <sys/ipm.h>

#define	NFDS	10

int	fd[NFDS];

main()
{
	fd_set rv;
	register char *p;
	register i;
	struct mesghdr mh;
	int catch();

	signal(SIGINT, catch);
	signal(SIGTERM, catch);
	for (i = 0; i < NFDS; i++)
		fd[i] = msgbind(i+1);
	for (;;) {
		FD_ZERO(rv);
		for (i = 0; i < NFDS; i++)
			FD_SET(fd[i], rv);
		i = select(fd[NFDS-1]+1, &rv, (fd_set *)0, 999999);
		if (i == -1) {
			perror("select");
			exit(1);
		}
		for (i = 0; i < NFDS; i++)
			if (FD_ISSET(fd[i], rv)) {
				p = msgrecv(fd[i], &mh);
				printf("reader:\n\n\n");
				hexdump(&mh, sizeof mh);
				hexdump(p, mh.length);
				msgfree(p);
			}
	}
}

catch()
{
	exit(0);
}
