/* lrconfig.c:  activate lan redundancy protocol */

#include <stdio.h>
#include <sys/enio.h>
#include <sys/ethernet.h>
#include <sys/filio.h>

main(argc, argv)
	int argc;
	char *argv[];
{
	extern lr_ld;
	short etype = 0xbad3;
	int a_fd, b_fd;

	if (argc != 3) {
		fprintf(stderr, "usage: %s lanA lanB\n", argv[0]);
		exit(1);
	}
	setpgrp(getpid(), getpid());
	if ((a_fd = open(argv[1], 2)) == -1) {
		perror(argv[1]);
		exit(1);
	}
	if ((b_fd = open(argv[2], 2)) == -1) {
		perror(argv[2]);
		exit(1);
	}
	if (ioctl(a_fd, ENIOTYPE, &etype) == -1) {
		perror("ioctl on A\n");
		exit(1);
	}
	if (ioctl(b_fd, ENIOTYPE, &etype) == -1) {
		perror("ioctl on B\n");
		exit(1);
	}
	if (ioctl(a_fd, FIOPUSHLD, &lr_ld) == -1) {
		perror("push on A");
		exit(1);
	}
	if (ioctl(b_fd, FIOPUSHLD, &lr_ld) == -1) {
		perror("push on B");
		exit(1);
	}
	for (;;)
		pause();
}
