/*		Copyright (c) 1985 AT&T		*/
/*		All Rights Reserved		*/
/*	@(#)stak.h	8.1		*/
/*
 *	UNIX shell
 *
 *	Bell Telephone Laboratories
 *
 */

/* To use stack as temporary workspace across
 * possible storage allocation (eg name lookup)
 * a) get ptr from `relstak'
 * b) can now use `pushstak'
 * c) then reset with `setstak'
 * d) `absstak' gives real address if needed
 */
#define	relstak()	(staktop-stakbot)
#define	absstak(x)	(stakbot+Rcheat(x))
#define	setstak(x)	(staktop=absstak(x))
#define	pushstak(c)	(*staktop++ = (c), \
				staktop == stakend ? growstak(BRKINCR) \
					: 0)
#define	zerostak()	(*staktop=0)

/* Used to address an item left on the top of the stack (very temporary) */
#define	curstak()	(staktop)

/* `usestak' before `pushstak' then `fixstak'
 * These routines are safe against heap
 * being allocated.
 */
#define	usestak() {locstak();}
extern char *locstak();		/* for local use only */
#define	fixstak() endstak(staktop)	/* return address of time after alloc*/
extern char *endstak();		/* hand back new stack top and allocate */
extern char *cpystak();		/* copy a string on stack and allocate space */
extern char *getstak();		/* Allocate given ammount of stack space */

/* A chain of ptrs of stack blocks that
 * have become covered by heap allocation.
 * `tdystak' will return them to the heap.
 */
extern struct blk *stakbsy;
extern char *stakbas;		/* Base of the entire stack */
extern char *stakend;		/* Top of entire stack */
extern char *stakbot;		/* Base of current item */
extern char *staktop;		/* Top of current item */
extern char *savstak();		/* Used with tdystak */

