/*
 * kill - send signal to process
 */

#include <signal.h>
#include <string.h>

main(argc, argv)
char **argv;
{
	register signo, pid, res;
	int errlev;
	int killpg;  /* 0=kill, 1=killpg */
	extern char *sys_errlist[];
	extern errno;

	if (strchr(argv[0], 'g'))
		killpg = 1;
	else
		killpg = 0;
	errlev = 0;
	if (argc <= 1) {
	usage:
		if (!killpg) {
			printf("usage: kill [ -signo ] pid ...\n");
			exit(2);
		}
		printf("usage: killpg [ -signo ] pgrp ...\n");
		exit(2);
	}
	if (*argv[1] == '-') {
		signo = atoi(argv[1]+1);
		argc--;
		argv++;
	} else
		signo = SIGTERM;
	argv++;
	while (argc > 1) {
		if (**argv<'0' || **argv>'9')
			goto usage;
		if (!killpg) {
			res = kill(pid = atoi(*argv), signo);
		} else {
			res = kill(pid = -atoi(*argv), signo);
		}
		if (res<0) {
			printf("%u: %s\n", pid, sys_errlist[errno]);
			errlev = 1;
		}
		argc--;
		argv++;
	}
	return(errlev);
}
