/* ip_var.h:  Definitions for ip protocol */

#define	NIPLD		8
#define	NARP		100
#define	NIPDEV		18	/* must include 17 - udp */
#define	NUDPDEV		32

union	ifs	{		/* ip interface structure */
	int	index;
	struct	ipif	{
		struct	queue	*queue;
		int		flags;
		int		mtu;
		in_addr		thishost;
		in_addr		that;
		in_addr		mask;
		in_addr		broadcast;
		int		ipackets, ierrors;
		int		opackets, oerrors;
		int		arp;
		int		dev;
	} ipif;
};

/* values for flags */

#define	IP_DIDLE		0001
#define	IP_DINPACKET	0002	/* currently interior to packet */
#define	IP_DTOSSING	0004	/* throwing away a packet */
#define	IP_UIDLE	0010	/* beginning of frame */
#define	IP_UPACKET	0020	/* currently in a packet */
#define	IP_UTOSSING	0040	/* trowing a packet away */
#define	IP_ARP		0100	/* this interface uses ethernet */



struct	iphdr	{		/* internet header struct */
	u_char	ver_ihl;	/* version and ihl */
	u_char	tos;		/* type of service */
	u_short	tlen;		/* total length */
	u_short	id;		/* datagramm id */
	u_short	fragnflag;	/* frag and flags */
	u_char	ttl;		/* time to live */
	u_char	proto;		/* protocol */
	u_short	chksum;		/* simple check sum */
	u_long	src;		/* source address */
	u_long	dest;		/* destination address */
};

/* macros for access fields */

#define	IP_VERSION(b)		(((b) >> 4) & 0xf)
#define	IP_IHL(b)		((b) & 0xf)
#define	IP_VER_IHL(v, l)	(((v)&0xf)<<4|((l)&0xf)

/* type of service */

#define	IP_LOW_DELAY	0020
#define	IP_HIGH_THRU	0010
#define	IP_HIGH_RELI	0004
#define	IP_NC		0340	/* network control */
#define	IP_INC		0300	/* internetwork control */
#define	IP_CRITIC	0240	/* critic/ecp */
#define	IP_FLASH_OVR	0200	/* flash override */
#define	IP_FLASH	0140	/* flash */
#define	IP_IMMED	0100	/* immediate */
#define	IP_PRIOR	0040	/* priority */
#define	IP_ROUTINE	0000	/* routine */

/* frag 'n flags */

#define	IP_DONTFRAG	040000	/* may fragment this packet */
#define	IP_MORE_FRAG	020000	/* more frags to follow */
#define	IP_FRAG_OFF(x)	((x) & 017777)

/* optins stuff to be added later */

struct	ipdev	{		/* ip pseudo-device state */
	int	flag;		/* flag word */
	struct	queue	*queue;	/* upstream queue */
	struct	ipif	*ifsp;	/* pointer to current interface */
				/*  reset after delimiters */
	in_addr		gate;	/* where to send it */
};

#define	IPOPEN		001

/* definitions of protocol values */
#define	IP_PROTO_UDP	17
#define	IP_PROTO_TCP	6
#define	IP_PROTO_ICMP	1

/* stuff for udp */

struct	udpdev	{		/* udp socket entries */
	struct	queue	*queue;	/* for this device */
	in_addr		laddr;	/* local internet address */
	in_addr		faddr;	/* foreign internet address */
	u_long		lport;	/* local port number */
	u_long		fport;	/* foreign port */
	in_addr		src;	/* current packets source address */
	in_addr		dest;
	u_short		state;	/* current state of socket */
	u_short		qstate;
	u_short		len;		/* bytes left in current packet */
};

/* values for qstate */

#define	UF_IDLE		0		/* between packets */
#define	UF_IPSEEN	1		/* src & dest valid */
#define	UF_HDRSEEN	2		/* header processed */
#define	UF_TOSS		3		/* port closed */
