/* mktape.c: Create a boot tape */
/* Because of the stupid way the SunOS 4.0.3 tape driver works */
/* I have to use this code to build a boot tape */
#define	TAPEDEVICE	"/dev/rst0"
#define	TSTRAP		"tstrap"
#define	BOOT		"boot"

char	*strap = TSTRAP;
char	*boot = BOOT;
char	*dev = TAPEDEVICE;

main(argc, argv)
	int argc;
	char *argv[];
{
	char buffer[512];
	int infd, outfd;

	if (argc > 3)
		dev = argv[3];
	if (argc > 2)
		strap = argv[2];
	if (argc > 1)
		boot = argv[1];
	if ((outfd = open(dev, 2)) == -1) {
		perror(TAPEDEVICE);
		exit(1);
	}
	if ((infd = open(strap, 0)) == -1) {
		perror(strap);
		exit(1);
	}
	read(infd, buffer, sizeof buffer);
	write(outfd, buffer, sizeof buffer);
	close(infd);
	if ((infd = open(boot, 0)) == -1) {
		perror(boot);
		exit(1);
	}
	lseek(infd, 0x20, 0);	/* skip the header */
	while (read(infd, buffer, sizeof buffer) > 0)
		write(outfd, buffer, sizeof buffer);
	close(infd);
	close(outfd);
	exit(0);
}
