/* RWDOCS */
#ifndef NEDL_H
#define NEDL_H
/* filename	: nedl.h
 * purpose	: constants and data types to support
 *		  the NE1000/NE2000 Ethernet device
 *		  under COHERENT 4.2
 *		  ((C)) Copyright 1994 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#define	NE_MAX	3

extern unsigned nec;	/* Actual number of Ethernet controllers */

/* Find base address of specified device */
#define	IE(dev)	(ne_dev[dev].addr)

struct estats {
	long recv;		/* Good packets received */
	long bad;		/* Bad receive packets */
	long over;		/* Overflow errors */
	long drop;		/* Dropped because RX queue too long */
	long nomem;		/* Dropped because buffer malloc failed */
	long intrpt;		/* Interrupts */
	long xmit;		/* Total output packets */
	long timeout;		/* Transmitter timeouts */
	long jam;		/* Collisions */
	long jam16;		/* 16 successive collisions */
};
struct ne {
	unsigned base;		/* Base I/O address */
	unsigned vec;		/* Interrupt vector */
	struct mbuf *rcvq;	/* Queue of incoming packets */
	unsigned rcvcnt;	/* Number of packets on queue */
	unsigned rcvmax;	/* Maximum length of rcvq */
	struct estats estats;	/* Controller statistics */
	int size;		/* Size of current transmit packet */
	int fd;			/* the file descriptor */
	struct interface *iface;
};

extern struct ne ne[];

#endif /* NEDL_H */
/* RWDOCE */
