/* RWDOCS */
#ifndef ENET_H
#define ENET_H
/* filename	: enet.h
 * purpose	: constants & defs for ethernet
 * Author	: Randy Wright
 * Copyright	((C)) 1994 Randy Wright
 *
 * this file is copyright and not public domain. anyone
 * may copy this file, redistribute it and store it in any
 * medium they see fit provided they do not charge for the
 * "content" of this file and they do not remove this notice
 * or the copyright notice.
 * 
 *
 */

#define	EADDR_LEN	6

/* Format of an Ethernet header, as it occurs on the wire */
struct ether {
	char dest[EADDR_LEN];
	char source[EADDR_LEN];
	int16 type;
};

	/* complete ethernet header length */
#define	ETHERLEN	14

	/* Ethernet broadcast address */
extern char ether_bdcst[];

	/* Ethernet type fields */
#define	IP_TYPE		0x800	/* Type field for IP */
#define	ARP_TYPE	0x806	/* Type field for ARP */

	/* ethernet packet sizes */
#define	RUNT		60	/* smallest legal size packet, no fcs */
#define	GIANT		1514	/* largest legal size packet, no fcs */

#define	MAXTRIES	16	/* Maximum number of transmission attempts */

struct mbuf *htonether();
void eproc();

/* RWDOCS */
#endif /* ENET_H */

