#
/*  C compiler	( file - c05.c )

Copyright 1972 Bell Telephone Laboratories, Inc.

*/

#include "c0h.c"


struct	swtab	swtab[swsiz];
extern	char	etoa[];
extern	char	atoe[];

int	machine;


struct hshtab *lookup() {  /*  returns a pointer to a hshtab structure member  */
	int ihash;
	register struct hshtab *rp;
	register char *sp, *np;
	char *delp;
	int delpen, lpctr;

	ihash = 0;
	delpen = YES;
	lpctr = 0;
	for (sp=symbuf; sp<symbuf+ncps;)	/*  zero padded - always pick up 8  */
						/* symbuf is a pointer to the input word. */
		ihash =+ *sp++ & 0377;	/* get a number to hash with. */
	rp = &hshtab[ihash%hshsiz];	/* get initial hashed pointer.  */
	while (*(np = rp->name)) {	/* look while items in the table are nonzero. */
		if ((delpen == YES) && ((rp->hflags & DELETED) == DELETED)
				    && ((rp->hflags & GLOBAL) == 0)) {
			delp = rp;
			delpen = NO;
		}
		for (sp=symbuf; sp<symbuf+ncps;)
			if ((*np++&0377) != *sp++)
				goto no;
		/* A match has been found. */
		if ((rp->hflags & DELETED) == DELETED)  goto insertname;
		return(rp);
	no:
		if (++lpctr >= hshsiz) goto insert;
		if (++rp >= &hshtab[hshsiz])
			rp = hshtab;
	}

	insert:
	if (delpen == NO)  rp = delp;
	insertname:
	if(++hshused >= hshsiz) {
		error("Symbol table overflow");
		cexit(1);
	}
	rp->hclass = 0;
	rp->htype = 0;
	rp->hoffset = 0;
	rp->hdimp = 0;
	rp->hflags = 0;
	sp = symbuf;
	if (xdflg)
		rp->hflags =| PERM;	/*  non-deletable  */
	for (np=rp->name; sp<symbuf+ncps;)
		*np++ = *sp++;	/*  copy name into symbol table  */
	return(rp);
}

symbol() {
	register c;
	register char *sp;
	int base,i,state;
	static char dig[32];
	long cv2;

	if (peeksym>=0) {
		c = peeksym;
		peeksym = -1;
		if (c==NAME)
			mosflg = 0;
		return(c);
	}
	if (peekc) {
		c = peekc;
		peekc = 0;
	} else
		if (eof)
			return(EOF);
		else
			c = getchar();
loop:
	switch(getctab(c)) {   /*  Ctab is a character set dependant table, initialized in c04.c.  */

	case INSERT:		/* ignore next newline on # inserted files. */
		inhdr = 1;
		c = getchar();
		goto loop;

	case NEWLN:
		if (!inhdr)
			line++;
		inhdr = 0;

	case SPACE:
		c = getchar();
		goto loop;

	case EOF:
		eof++;
		return(0);

	case PLUS:
		return(subseq(c,PLUS,INCBEF));

	case MINUS:
		return(subseq(c,subseq('>',MINUS,ARROW),DECBEF));

	case ASSIGN:
		if (subseq(' ',0,1)) return(ASSIGN);
		c = symbol();
		if (c>=PLUS && c<=EXOR)
			return(c+30);
		if (c==ASSIGN)
			return(EQUAL);
		peeksym = c;
		return(ASSIGN);

	case LESS:
		if (subseq(c,0,1)) return(LSHIFT);
		return(subseq('=',LESS,LESSEQ));

	case GREAT:
		if (subseq(c,0,1)) return(RSHIFT);
		return(subseq('=',GREAT,GREATEQ));

	case EXCLA:
		return(subseq('=',EXCLA,NEQUAL));

	case DIVIDE:
		if (subseq('*',1,0))
			return(DIVIDE);
com:   /*  Process a comment.  */
		c = getchar();
com1:
		switch(c) {
		case '\0':
			eof++;
			error("Nonterminated comment");
			return(0);
		case '\n':
			if (!inhdr)
				line++;
			inhdr = 0;
			goto com;
		case 001:		/* SOH, insert marker */
			inhdr++;
		default:
			goto com;
		case '*':
			c = getchar();
			if (c!='/')
				goto com1;
		}    /*  End processing a comment.  */
		c = getchar();
		goto loop;

	case PERIOD:
		c = getchar();
		if(c>='0' && c<='9' ) {
			dig[0] = '.';
			i=1;
			goto fc;
		}
		/* not floating point; structure reference */
		peekc = c;
		return (DOT);
	case DIGIT:	
		cv2 = 0;
		i = 0;
		base = (c=='0') ? 8 : 10;
		while (c>='0' && c<='9') {
			cv2 = (cv2*base-'0')+c;
			dig[i++] = c;
			c = getchar();
			}
		if( c=='.' || c=='d' || c=='D' || c=='e' || c=='E' ) goto fc;
		peekc = c;
#ifdef unix
	if(cv2.integ != 0 || cv2.integ2 < 0) {
		cval = &cv2;
		return(LCON);
	}
#endif
	cval = cv2;
		return (CON);

	fc:	/* convert floating point constant */
		state = 0; /* haven't seen d */

		for( ;; c=getchar() ) {

			switch(c) {
		
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case '0':
			case '.':
				dig[i++] = c;
				if (state) state=2;
				continue;
			case 'd':
			case 'D':
			case 'e':
			case 'E':
				dig[i++] = '%';
				dig[i++] = 'c';
				if(state!=0) error("illegal floating point constant");
				state = 1;
				continue;
			case '+':
			case '-':
				if(state==1) {
					dig[i++] = c;
					continue;
					}

				}

			/*otherwise, and + and - not preceded by d */
			break;
			}

		/* we now have collected the digits; output the number */
		if(state==0) {
			dig[i++] = '%';
			dig[i++] = 'c';
			dig[i++] = '0';
			}
		peekc = c;
		dig[i++] = '\0';
		fcval = dig;
		return(FCON);

	case DQUOTE:
		return(STRING);	/* return, but dont get contents */

	case SQUOTE:
		return(getcc());	/*  Only call of getcc.  */

	case LETTER:
		sp = symbuf;	/* Put a word into symbol buffer - then call lookup.  */
		if (mosflg) {
			*sp++ = '.';
			mosflg = 0;
		}
		while(getctab(c)==LETTER || getctab(c)==DIGIT) {
			if (c == '_') c = '#';
			if (sp<symbuf+ncps) *sp++ = c;
			c = getchar();
		}
		while(sp<symbuf+ncps)	/* Pad symbuf with zeros. */
			*sp++ = '\0';
		peekc = c;
		csym = lookup();
		if (csym->hclass==KEYWC) {
			if (csym->htype==SIZEOF)
				return(SIZEOF);
			cval = csym->htype;
			return(KEYW);
		}
		return(NAME);

	case AND:
		return(subseq('&', AND, LOGAND));

	case OR:
		return(subseq('|', OR, LOGOR));

	case UNKN:
		error("Unknown character");
		c = getchar();
		goto loop;

	}
	return(getctab(c));
}	/*  End of Symbol function.  */

subseq(c,a,b) {
	if (!peekc)
		peekc = getchar();
	if (peekc != c)
		return(a);
	peekc = 0;
	return(b);
}

getstr() {	/* get string - processes something in double quotes. */
	register int c;	
	register int slpctr;

	nchstr = 1;
	printf("$%d",cval = isn++);
	printf("	dc	x'");
	slpctr = 0;
	while((c=mapch('"')) >= 0) {
		if (slpctr >= 25) {
			slpctr = 0;
			printf("'\n	dc	x'");
		}
		printf("%02x", c);
		nchstr++;
		slpctr++;
	}
	if (nchstr<= 1)
		printf("00");
	printf("' \n	dc	x'00' \n");
}

getcc()	/* get a character constant (eg 'a'). */
{
	register int c, cc;

	cval = 0;
	cc = 0;
	while((c=mapch('\'')) >= 0)
		{cc++;
		if(cc<=2) cval = (cval<<8) + c; }
	if(cc>2)  /* don't allow char const > 2 char */
		error("Long character constant");
	return(CON);
}

mapch(ac)	/* map character - implements the escapes (eg \n). */
{
	register int a, c;

	c = ac;
loop:
	if((a=getchar())==c)
		return(-1);
	switch(a) {

	case '\n':
	case '\0':
		error("Nonterminated string");
		peekc = a;
		return(-1);

	case '\\':	/*  Return numerical value of ebcdic character.  */
		switch (a=getchar()) {

		case 't':
			return(011);	/*  return('\t')  */

		case 'n':
			return(012);	/*  \n  line feed  */

		case 'b':
			return(010);	/*  \b,  backspace  */

		case '0':
			return(0);	/*  \0, null  */

		case 'r':
			return(13);	/*  \r,  carriage return  */

		case '\n':
			if (!inhdr)
				line++;
			inhdr = 0;
			goto loop;
		}

	}
	if (machine == UNIX)
		{
		return(a);
			}
	else	/*  machine is IBM  */
		return(etoa[a] & 0377);
}

getctab(c)
char c;
{
	if (machine == IBM)
		return(ctab[etoa[c]]);
	else	/*  machine is UNIX  */
		return(ctab[c]);
}
