*PROGRAM: CINOUT, AN OS/370 ASSEMBLY EXTERNAL FUNCTION
*LANGUAGE: OS/360 ASSEMBLER LANGUAGE
*AUTHOR: A L SABSEVITZ, BTL DEPT 9152, RRC 4C-830, X6343
* WRITTEN ORIGINALLY FOR SNOFLAKE AND SNOBOL4 USAGE BY T B MUENZER
* REVISED MAY 21, 1971, T B MUENZER, TO TIGHTEN UP CODE
* REVISED FEBRUARY 7, 1972, T. B. MUENZER, TO CORRECT PROGRAM BUG:
* WHEN ASKED TO WRITE NULL STRING, CINOUT WOULD FAIL TO BLANK FIRST
* BYTE OF OUTPUT BUFFER AND WOULD BLANK FIRST BYTE AFTER OUTPUT BUFFER.
* REVISED FEBRUARY 8, 1972, T. B. MUENZER, TO INSERT FREEPOOL
* INSTRUCTION TO FREE BUFFERS AFTER CLOSING DCB.
* REVISED OCTOBER 15, 1974, A. L. SABSEVITZ TO TIGHTEN UP CODE
* AND BE CALLABLE DIRECTLY FROM ASSEMBLY LANG PROGRAMS.
* REVISED NOV 1974, A. L. SABSEVITZ TO USE MVCL INSTR AND TO INTERACT
* WITH IBMC.
          SPACE
*
*   REVISED SEPT 1973 BY D. W. SMITH
*
*   ADD FACILITY TO HANDLE VARIABLE LENGTH RECORDS
*   REVISED FEB 1974, A. L. SABSEVITZ TO FIX BUG IN ABOVE FACILITY
*
          SPACE
*PURPOSE: TO MAKE OS/360 QSAM ACCESS METHOD ACCESSIBLE BY IBMC
* FOR READING AND WRITING FIXED AND VARIABLE LENGTH RECORD SEQUENTIAL
* DATA SETS INCLUDING (MULTIPLE) MEMBERS OF PARTITIONED DATA SETS
          SPACE
*RESTRICTIONS:
* STRINGS TO BE WRITTEN ARE TRUNCATED OR PADDED WITH BLANKS
* ON THE RIGHT TO LOGICAL RECORD LENGTH
          SPACE
* THE MODEL DCB IS CODED MACRF=(GL,PL) WHICH IMPLIES THAT
* PAPER TAPE CANNOT BE READ
          SPACE
* CONCATENATIONS OF PARTITIONED DATA SETS CANNOT BE PROCESSED
          SPACE
* THE FIRST AND SECOND ARGUMENT STRINGS MUST BE CODED IN IBM EBCDIC
          SPACE
* THE SUBSTRINGS DDNAME AND MEMBER IN THE FIRST ARGUMENT MUST NOT
* CONTAIN PARENTHESES (BELIEVED TO BE AN OS/360 RESTRICTION)
          EJECT
          SPACE
*USAGE: CINOUT(FILE,FUNCTION,STRING) WHERE
* FILE = 18 BYTE STRING IN THE FORM: DDNAME ; DDNAME '(' MEMBER ')' AND
* FUNCTION = 'R' ; 'W' ; 'C' AND
* STRING = ADDRESS OF STRING TO BE WRITTEN OR READ
          SPACE
* FILE = DDNAME IF THERE IS A DD STATEMENT OF THE FORM
* //DDNAME DD DSNAME=DATA-SET-NAME,....
* WHERE DATA-SET-NAME IS THE NAME OF A (FIXED-LENGTH RECORD,
* BLOCKED OR UNBLOCKED) SEQUENTIAL DATA SET
* OR IF THERE IS A DD STATEMENT OF THE FORM
* //DDNAME DD DSNAME=DATA-SET-NAME(MEMBER),....
* WHERE DATA-SET-NAME IS THE NAME OF A (FIXED-LENGTH RECORD,
* BLOCKED OR UNBLOCKED) PARTITIONED DATA SET
          SPACE
* FILE = DDNAME '(' MEMBER ')' IF THERE IS A DD STATEMENT OF THE FORM
* //DDNAME DD DSNAME=DATA-SET-NAME,...
* WHERE DATA-SET-NAME IS THE NAME OF A (FIXED-LENGTH RECORD,
* BLOCKED OR UNBLOCKED) PARTITIONED DATA SET
          SPACE
* CINOUT MAINTAINS A LIST OF DCB'S FOR PROCESSING SUCH DATA SETS
          SPACE
* CINOUT(FILE,'R',STRING) RETURNS:
*  1. NUMBER OF BYTES READ       OR
*  2. 0 IF EOF                   OR
*  3. NEGATIVE NUMBER IF ERRORS
          SPACE
* CINOUT(FILE,'W',STRING) RETURNS:
*  1. NEGATIVE NUMBER IF ERRORS
         SPACE
* IF THE FIRST OR SECOND ARGUMENT IS MISSPELLED,
* IF NO DD STATEMENT WAS SUPPLIED, OR IF OPEN FAILS
          SPACE
* CINOUT AS CURRENTLY PROGRAMMED TOLERATES CERTAIN ILLEGAL ARGUMENTS
* THIS INFORMATION IS FOR DEBUGGING PURPOSES ONLY AND IS NOT PART
* OF THE DEFINITION OF WHAT THE PROGRAM IS SUPPOSED TO DO
* PROGRAMMERS TAKE ADVANTAGE OF THIS INFORMATION AT THEIR PERIL
* CINOUT TOLERATES A DDNAME, MEMBER, OR FUNCTION PADDED WITH BLANKS
* TO NOT MORE THAN 8 CHARACTERS
* CINOUT ALSO TOLERATES CERTAIN ILLEGAL FIRST ARGUMENTS WHEN
* THE FUNCTION = 'C'
* IN PARTICULAR, THE FOLLOWING ALL HAVE THE SAME EFFECT:
* CINOUT('DDNAME(GARBAGE)','C')
* CINOUT('DDNAME(MEMBER)','C')
* CINOUT('DDNAME','C')
          SPACE
* CINOUT MAY BE COMPARED WITH FORTRAN INPUT/OUTPUT
* CINOUT(DDNAME,'R',STRING) IS APPARENTLY ABOUT 3 TIMES AS FAST AS
* A SNOBOL4 INPUT ASSOCIATION
          EJECT
* THIS PROGRAM IS A REVISION OF A PROGRAM OF THE SAME NAME WRITTEN BY
* I BENYACAR, BTL DEPT 3344, HO 2E-412, X5656, JULY 23, 1968
          SPACE
* THIS PROGRAM IS INTENDED TO PRESERVE ALL FUNCTIONAL PROPERTIES OF
* THAT PROGRAM, EXCEPT IN THE FOLLOWING RESPECTS:
* 1. THE MAXIMUM LIMIT OF 25 SIMULTANEOUSLY OPEN DATA SETS HAS BEEN
* ELIMINATED
* 2. BLOCKSIZE, RECORD FORMAT, AND LOGICAL RECORD LENGTH OF
* DATA SETS TO BE WRITTEN MUST BE DEFINED IN THE DD STATEMENT
* OR DATA SET LABEL, RATHER THAN IN THE DCB
* 3. ON END OF FILE, OR ON CHANGE OF MEMBER FOR A GIVEN DDNAME,
* THE DATA SET IS CLOSED AUTOMATICALLY
          EJECT
* THIS PROGRAM EXTENDS THE FUNCTIONAL PROPERTIES OF THAT PROGRAM IN
* THE FOLLOWING RESPECT:
          SPACE
* WHAT MEMBER OF A PARTITIONED DATA SET IS TO BE READ OR WRITTEN MAY BE
* SPECIFIED IN A IBMC FUNCTION REFERENCE, RATHER THAN ONLY IN A
* DD STATEMENT
* DIFFERENT MEMBERS MAY BE SPECIFIED FOR THE SAME DDNAME AT DIFFERENT
* TIMES, SO THAT MULTIPLE MEMBERS OF A PARTITIONED DATA SET CAN BE
* PROCESSED THROUGH A SINGLE DD STATEMENT
* ONLY ONE MEMBER ASSOCIATED WITH A DDNAME CAN BE PROCESSED AT A
* TIME, HOWEVER
* WHEN A DIFFERENT MEMBER IS SPECIFIED, CINOUT CLOSES ITS DCB FOR THE
* GIVEN DDNAME, ALTERS THE JOB FILE CONTROL BLOCK, AND REOPENS
* THE DCB FOR THE NEWLY-SPECIFIED MEMBER
* IF IT IS NECESSARY TO PROCESS SEVERAL MEMBERS OF A PARTITIONED
* DATA SET CONCURRENTLY, SEVERAL DD STATEMENTS REFERRING TO THE
* SAME PARTITIONED DATA SET MAY BE USED
* NATURALLY, ONLY ONE MEMBER OF A PARTITIONED DATA SET CAN BE
*   W R I T T E N   AT A TIME
* NOTE THAT THIS METHOD OF PROCESSING MEMBERS OF PARTITIONED DATA SETS
* WILL, ON OUTPUT, UPDATE THE DIRECTORY ENTRY FOR A MEMBER, BUT
* WILL NOT UPDATE ANY DIRECTORY ENTRIES FOR ALIASES
* NOTE THAT, UNDER THIS METHOD OF WRITING MEMBERS OF PARTITIONED DATA
* SETS, OS/360 REQUIRES A DD STATEMENT DISPOSITION OF OLD IF EXISTING
* MEMBERS ARE TO BE REPLACED (COMPARE OS/360 LINKAGE EDITOR SYSLMOD
* DD STATEMENT)
          SPACE
* REFERENCES: BTL IBM SYSTEM/360 PROGRAMMING MANUALS
* STRAUSS H J, EXTERNAL FUNCTION FOR SNOBOL4, MM-68-3344-3
* IBM OS/360 SYSTEM PROGRAMMER'S GUIDE, C28-6550
* IBM OS/360 SYSTEM CONTROL BLOCKS, C28-6628
          SPACE
* THE METHOD OF PROCESSING MEMBERS OF PARTITIONED DATA SETS IS TO
* OPEN AND CLOSE THE DATA SET FOR EACH MEMBER (YES)
* ALTERING THE JOB FILE CONTROL BLOCK BY SUPPLYING JFCBELNM AND BY
* SETTING BIT 7 OF JFCBIND1
* THIS METHOD IS CHOSEN FOR THE CONVENIENCE OF USING QSAM RATHER
* THAN BPAM
          SPACE
* NOTE THAT (IT HAS BEEN DISCOVERED BY EXPERIMENT THAT) OS/360
* PROVIDES A CAPABILITY FOR READING THE DIRECTORY OF A PARTITIONED
* DATA SET AS A SEQUENTIAL DATA SET
* IT IS NECESSARY ONLY TO SUPPLY A DD STATEMENT OF THE FORM
* //DDNAME DD DSNAME=DATA-SET-NAME,
* // DCB=(RECFM=FS,LRECL=256,BLKSIZE=256),....
* THE IBM OS/360 UTILITIES MANUAL (IEBPTPCH) ALLUDES TO BUT DOES NOT
* EXPLAIN THIS CAPABILITY
* NOTE THAT WELL-DEFINED BUT STRANGE RESULTS ARE TO BE EXPECTED
* IF THE DIRECTORY OF A PARTITIONED DATA SET IS BEING READ AS A
* SEQUENTIAL DATA SET WHILE THE DIRECTORY IS BEING UPDATED BY
* THE ADDITION OF NEW MEMBERS
          EJECT
* EXTENDED MNEMONIC CODES NOT SUPPLIED BY IBM
*          MACRO
*&SYMBOL   BHR
*&SYMBOL   BCR   2,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BLR
*&SYMBOL   BCR   4,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BER
*&SYMBOL   BCR   8,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNHR
*&SYMBOL   BCR   13,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNLR
*&SYMBOL   BCR   11,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNER
*&SYMBOL   BCR   7,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BOR
*&SYMBOL   BCR   1,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BPR
*&SYMBOL   BCR   2,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BMR
*&SYMBOL   BCR   4,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BZR
*&SYMBOL   BCR   8,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNOR
*&SYMBOL   BCR   14,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNPR
*&SYMBOL   BCR   13,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNMR
*&SYMBOL   BCR   11,&SYSLIST(1)
*          MEND
*          MACRO
*&SYMBOL   BNZR
*&SYMBOL   BCR   7,&SYSLIST(1)
*          MEND
          EJECT
* LOAD IMMEDIATE
          MACRO
&SYMBOL   LI    &REG,&ABSEXP
&SYMBOL   LA    &REG,&ABSEXP.(0,0)
          MEND
* INCREMENT REGISTER
          MACRO
&SYMBOL   INCR  &REG
&SYMBOL   LA    &REG,1(0,&REG)
          MEND
* DECREMENT REGISTER
          MACRO
&SYMBOL   DECR  &REG
&SYMBOL   BCTR  &REG,0
          MEND
* CALL TO A NON-EXTERNAL SYMBOL
          MACRO
&SYMBOL   CALL
&SYMBOL   BAL 14,&SYSLIST(1)
          MEND
          EJECT
          MACRO
          IEFJFCBN
* PARTIAL DSECT FOR JOB FILE CONTROL BLOCK
* SEE IBM OS/360 SYSTEM PROGRAMMER'S GUIDE, IEFJFCBN MACRO INSTRUCTION
INFMJFCB EQU   *
          DS    CL44
JFCBELNM DS    CL8
          DS    CL34
JFCBIND1 DS    BL1
          DS    CL89
          MEND
          EJECT
          MACRO
          SAVED
* DSECT FOR SAVE AREA
SAVED     DSECT
WD1       DS    F
HSA       DS    F
LSA       DS    F
RET       DS    F
EPA       DS    F
R0        DS    F
R1        DS    F
R2        DS    F
R3        DS    F
R4        DS    F
R5        DS    F
R6        DS    F
R7        DS    F
R8        DS    F
R9        DS    F
R10       DS    F
R11       DS    F
R12       DS    F
          MEND
          EJECT
          MACRO
&SYMBOL   NULL
* STORE THE NULL STRING
*   RETURN BYTE SIZE OF ZERO TO CALLER
&SYMBOL  SR    0,0
         MEND
          EJECT
          MACRO
&SYMBOL   RESULT
* PRODUCE THE RESULT OF THE EXTERNAL FUNCTION
          GBLC  &LANG
&SYMBOL   L     13,HSA
          L     14,RET
         LR    0,MAX
          AIF   ('&SYSLIST(1)' NE 'FAIL').DONE
         L     0,=F'-2'
.DONE     RETURN (2,12)
          MEND
          EJECT
          GBLC  &LANG
          GBLC  &CLOSE
          GBLA  &SZSADW           SNOFLAKE SET SYMBOL
&SZSADW   SETA  13   SNOFLAKE-DEPENDENT VALUE
&LANG     SETC  'SNOBOL4'
&CLOSE    SETC  'DISP'
*&CLOSE  SETC  'LEAVE'
          SPACE
CINOUT    START
*         PRINT NOGEN
* GENERAL PURPOSE REGISTER ALLOCATION
MAX       EQU   2
ADDRESS   EQU   4
LENGTH    EQU   5
TO        EQU   6
HEAD      EQU   3
ELEMENT   EQU   11
DCB       EQU   8
PROCESS   EQU   9
BASE      EQU   10
WORK      EQU   7
ARGLIST   EQU   12
*   FLAG SETTINGS FOR DCBRECFM     9/73 DWS
FIXED     EQU  B'10000000'    9/73 DWS
VARBLE    EQU  B'01000000'    9/73 DWS
BLCKD     EQU  B'00010000'    9/73 DWS
          EJECT
          DCBD  DSORG=(QS)
          SPACE
JFCBD     DSECT
          IEFJFCBN
          SPACE
          SAVED
          EJECT
BLOCK     DSECT
* MASK FOR ELEMENTS OF LIST OF DCB'S
QSAM      DCB   DSORG=PS,MACRF=(GL,PL)
DCBNEXT   DS    A
DCBPREV   DS    A
DCBNAME   DS    CL8
DCBMEMB   DS    CL8
DCBFNCN   DS    CL8
LENBLOCK EQU   *-BLOCK
          SPACE
* DSECT FOR ARGUMENT LIST
ARGVEC    DSECT
FILE      DS    F
FUNCTION DS    F
STRING    DS    F
LEN      DS    F
          EJECT
CINOUT    CSECT
* SAVE REGISTERS, ESTABLISH ADDRESSABILITY, CHAIN SAVE AREAS
          SAVE  (14,12)
          LR    BASE,15 CONTAINING ADDRESS OF THIS PROGRAM
          USING CINOUT,BASE TO ADDRESS THIS PROGRAM
          LA    WORK,SAVEAREA OF THIS PROGRAM
          USING SAVED,WORK TO ADDRESS SAVE AREA OF THIS PROGRAM
          ST    13,HSA IN SAVE AREA OF THIS PROGRAM
          DROP  WORK
          USING SAVED,13 TO ADDRESS SAVE AREAS
          ST    WORK,LSA IN SAVE AREA OF CALLING PROGRAM
          LR    13,WORK CONTAINING ADDRESS OF SAVE AREA THIS PROGRAM
* OBTAIN ARGUMENT LIST ADDRESS
          LR    ARGLIST,1 CONTAINING ADDRESS OF ARGUMENT LIST
          USING ARGVEC,ARGLIST TO ADDRESS THE ARGUMENT LIST
* FETCH AND CHECK FIRST ARGUMENT
FETCH1  L    ADDRESS,FILE
      LA     LENGTH,18
          CALL  SEARCH FOR FIRST ( )
          BNZ   PDSFILE IF ARGUMENT CONTAINS ( )
          SPACE
* FIRST ARGUMENT HAS FORM DDNAME
SEQFILE  MVC   DDNAME,0(ADDRESS)
          MVC   MEMBER,=C'        ' TO BLANK MEMBER
          B     FETCH2
          EJECT
* FIRST ARGUMENT HAS FORM DDNAME '(' MEMBER ')' (PROBABLY)
PDSFILE   CLI   0(1),C'('
          BNE   FAIL IF NOT LEFT PAREN
          LR    WORK,LENGTH PRESERVING LENGTH OF FIRST ARGUMENT
          SR    1,ADDRESS DEVELOPING LENGTH UP TO LEFT PAREN
          LR    LENGTH,1
         BCTR  1,0
* STORE DDNAME
         MVC   DDNAME,=C'        '
         LA    TO,DDNAME
         EX    1,MOVECHAR
          SPACE
* TAKE REMAINDER OF FIRST ARGUMENT
          LA    ADDRESS,1(LENGTH,ADDRESS) SKIPPING LEFT PAREN
          SR    WORK,LENGTH DEVELOPING LENGTH OF REMAINDER
          DECR  WORK SKIPPING LEFT PAREN
          LR    LENGTH,WORK
          CALL  SEARCH FOR SECOND ( )
          CLI   0(1),C')'
          BNE   FAIL IF NOT RIGHT PAREN
         SR    1,ADDRESS
         LR    LENGTH,1
          DECR  LENGTH SKIPPING RIGHT PAREN
         MVC   MEMBER,=C'        '
         LA    TO,MEMBER
         EX    LENGTH,MOVECHAR
          B     FETCH2
          EJECT
* SUBROUTINE SEARCH
* SEARCH A STRING FOR LEFT OR RIGHT PARENTHESIS
* IMPLICIT ARGUMENTS (ADDRESS), (LENGTH)
* RETURNS (1), (2), CONDITION CODE
SEARCH    LTR   1,LENGTH
          BNP   FAIL ON NON-POSITIVE STRING LENGTH
          DECR  1 TO MACHINE LENGTH FORM
          EX    1,TRANS
          RETURN
TRANS     TRT   0(0,ADDRESS),TRTABLE
* TABLE ALL ZERO EXCEPT FOR ( )
TRTABLE   DC    77X'00',C'(',15X'00',C')',162X'00'
          EJECT
FETCH2   MVC   FUNCNAME(1),FUNCTION
          SPACE
*DECISION TABLE.  DECODE AND PROCESS
*CONDITION                              RULES
*                                                1111111111222
*                                       1234567890123456789012
* DDNAME = DCBNAME                      -TTTTTTTTTTTTTTTTTTFFF
* MEMBER = DCBMEMB                      -TTTTTTTTTFFFFFFFFFUUU
* FUNCTION = R W C O  (CURRENT REQUEST) ORRRWWWCCCRRRWWWCCCRWC
* DCBFUNC = R W C     (PREV. REQUEST)   -RWCRWCRWCRWCRWCRWCUUU
*ACTION
* CLOSE                                 --X-X--XX-XX-XX-XX----
* SPLICE                                -------XXX------XXX---
* NEWDCB                                -------------------XX-
* OPEN                                  --XXX-X---XXXXXX---XX-
* GET                                   -XXX------XXX------X--
* PUT                                   ----XXX------XXX----X-
* NULL                                  ----XXXXXX---XXXXXX--X
* FAIL                                  X---------------------
*END OF DECISION TABLE
          EJECT
* DECODE FUNCTION
IFREAD    CLI   FUNCNAME,C'r'
          BE    READ
          CLI   FUNCNAME,C'R'
          BNE   IFWRITE
READ      LA    PROCESS,GET
          B     OKFUNC
IFWRITE   CLI   FUNCNAME,C'w'
          BE    WRITE
          CLI   FUNCNAME,C'W'
          BNE   IFCLOSE
WRITE     LA    PROCESS,PUT
          B     OKFUNC
IFCLOSE   CLI   FUNCNAME,C'c'
          BE    CLOSEP
          CLI   FUNCNAME,C'C'
          BNE   FAIL ON INVALID FUNCTION RULE 1
CLOSEP    LA    PROCESS,NULL
OKFUNC    EQU   *
          SPACE
* SEARCH LIST OF DCB'S FOR MATCHING DDNAME
          LA    HEAD,LISTHEAD HEADING TWO-WAY LIST OF DCB'S
          LR    ELEMENT,HEAD
          USING BLOCK,ELEMENT
MATCHDCB L     ELEMENT,DCBNEXT TAKING SUCCESSOR ELEMENT
          CR    ELEMENT,HEAD
          BE    NODCB IF LIST IS EXHAUSTED
          CLC   DDNAME,DCBNAME
          BNE   MATCHDCB IF NOT SAME DDNAME
          SPACE
* (ELEMENT) IS MATCHING DCB
* MAKE DCB FIELDS ADDRESSABLE
          LA    DCB,QSAM
          USING IHADCB,DCB TO ADDRESS DCB FIELDS
* IF MEMBER = DCBMEMB & FUNCNAME = DCBFUNC
          CLC   MEMBER(16),DCBMEMB
          BER   PROCESS RULES 2, 6, 10
          SPACE
* IT IS NECESSARY TO CLOSE THE DCB
* RULE 2 BECOMES 4; 5, 7; 11 AND 12, 13; 14 AND 15, 16
          CALL CLOSE
          SPACE
* IS THE FUNCTION CLOSE
          LA    WORK,NULL
          CR    WORK,PROCESS
          BNE   OPEN
          AIF   ('&CLOSE' EQ 'LEAVE').NULL
          CALL SPLICE
.NULL     B     NULL RULES 8, 9, 17, 18, 19
          EJECT
* COMPARE FUNCTION TO 'CLOSE' AND TERMINATE IF EQUAL
NODCB     LA    WORK,NULL
          CR    WORK,PROCESS
          BER   PROCESS
* OBTAIN STORAGE FOR DCB
NEWDCB    GETMAIN R,LV=LENBLOCK
          LR    ELEMENT,1
          SPACE
* SET UP DCB
          USING BLOCK,ELEMENT
          MVC   BLOCK(LENBLOCK),LISTHEAD
          SPACE
* ADD DCB TO LIST
          LA    HEAD,LISTHEAD
          DROP  ELEMENT
          USING BLOCK,HEAD
          L     WORK,DCBPREV
          ST    ELEMENT,DCBPREV
          DROP  HEAD
          USING BLOCK,WORK
          ST    ELEMENT,DCBNEXT
          DROP  WORK
          USING BLOCK,ELEMENT
          ST    HEAD,DCBNEXT
          ST    WORK,DCBPREV
* MAKE DCB FIELDS ADDRESSABLE
          LA    DCB,QSAM
          USING IHADCB,DCB TO ADDRESS DCB FIELDS
* SET DDNAME IN DCB
          MVC   DCBDDNAM,DDNAME
          EJECT
* CHECK WHETHER DD STATEMENT WAS SUPPLIED
OPEN      LA    WORK,JFCB
          USING INFMJFCB,WORK TO ADDRESS JOB FILE CONTROL BLOCK FIELDS
* JFCBELNM IS SUPPLIED BY THE SYSTEM AS BLANKS OR A NAME
          RDJFCB (QSAM),MF=(E,OPENLIST) SEE SYSTEM PROGRAMMERS GUIDE
         LTR   15,15
          BNZ   NOTOPEN WHEN NO DD STATEMENT WAS SUPPLIED
          SPACE
* CHECK WHETHER MEMBER OF PARTITIONED DATA SET
IFPDS     CLC   MEMBER,=C'        '
          BE    OPENUP IF FUNCTION REFERENCE SPECIFIED NO MEMBER
* SUPPLY JFCBELNM AND SET JFCBIND1
          MVC   JFCBELNM,MEMBER
          OI    JFCBIND1,B'00000001'
          DROP  WORK
          SPACE
* OPEN DCB FOR INPUT OR OUTPUT
OPENUP    LA    WORK,GET
          CR    WORK,PROCESS
          BE    OPENIN
          LA    WORK,PUT
          CR    WORK,PROCESS
          BE    OPENOUT
* FUNCTION NOT 'READ', NOT 'WRITE'
          B     NOTOPEN ON PROGRAM ERROR
* FOR OPEN TYPE=J SEE SYSTEM PROGRAMMERS GUIDE
OPENIN    OPEN  (QSAM,(INPUT,&CLOSE)),MF=(E,OPENLIST),TYPE=J
          B     IFOPEN
OPENOUT   OPEN  (QSAM,(OUTPUT,&CLOSE)),MF=(E,OPENLIST),TYPE=J
          SPACE
* CHECK WHETHER OPEN IS SUCCESSFUL
IFOPEN    TM    DCBOFLGS,B'00010000'
          BZ    NOTOPEN IF OPEN WAS UNSUCCESSFUL
* STORE MEMBER AND FUNCNAME IN LIST ELEMENT
OPENED    MVC   DCBMEMB(16),MEMBER
*          BRANCH TO GET, PUT, OR NULL.
          BR    PROCESS RULES 4, 7, 13, 16
          SPACE
* DATA SET COULD NOT BE OPENED
* NO DD STATEMENT, OPEN UNSUCCESSFUL, OR PROGRAM ERROR
NOTOPEN   MVI   DCBFNCN,C'C'
          AIF   ('&CLOSE' EQ 'LEAVE').FAIL
          CALL  SPLICE
.FAIL     B     FAIL IF DATA SET COULD NOT BE OPENED
          EJECT
* SUBROUTINE CLOSE
* CLOSE DCB QSAM
* IMPLICIT ARGUMENT (ELEMENT)
* USES (WORK)
* IS THE DCB ALREADY CLOSED
CLOSE     CLI   DCBFNCN,C'C'
          BE    CLOSED
          LR    WORK,14 PRESERVING RETURN POINT
          CLOSE (QSAM,&CLOSE),MF=(E,OPENLIST)
          MVI   DCBFNCN,C'C'
          LR    14,WORK RESTORING RETURN POINT
CLOSED    RETURN
          EJECT
* SUBROUTINE SPLICE
* SPLICE THE DCB (ELEMENT) OUT OF THE LIST OF DCB'S
* IMPLICIT ARGUMENT (ELEMENT)
          AIF   ('&CLOSE' EQ 'LEAVE').SPLICE
          USING BLOCK,ELEMENT
SPLICE    L     HEAD,DCBNEXT
          L     WORK,DCBPREV
          DROP  ELEMENT
          USING BLOCK,HEAD
          ST    WORK,DCBPREV
          DROP  HEAD
          USING BLOCK,WORK
          ST    HEAD,DCBNEXT
          DROP  WORK
          USING BLOCK,ELEMENT
          FREEMAIN R,A=(ELEMENT),LV=LENBLOCK
          RETURN
.SPLICE   ANOP
          EJECT
GET       GET   QSAM
          LH    LENGTH,DCBLRECL
         LR    MAX,LENGTH
         LR    WORK,MAX
         O     LENGTH,=X'40000000'
          MVC   PARM,DCBRECFM        ALS 3/7/74
          NC    PARM,X'C0'           ALS 3/7/74
          CLI   PARM,X'40'           ALS 3/7/74
          BNE   GET#ST                NOT V, ALS 3/7/74
          LA   1,4(,1) BUMP PTR PASSED RDW IN RECORD 9/73 DWS
          SH   LENGTH,=H'4' DECR LENGTH OF RECORD 9/73 DWS
         SH    WORK,=H'4'
         SH    MAX,=H'4'
GET#ST    EQU  *                   9/73 DWS
         L     TO,STRING
         LR    ADDRESS,1
         CALL  MOVE
          B     RETURN
          EJECT
* SUBROUTINE MOVE
* MOVE A CHARACTER STRING OF ANY LENGTH
* IMPLICIT ARGUMENTS (ADDRESS), (LENGTH), (TO), (WORK)
* USES (ADDRESS), (LENGTH), (TO)
* RETURNS (ADDRESS), (LENGTH), (TO)
MOVE      LTR   LENGTH,LENGTH
          BNP   DONEMOVE IF MOVING NULL STRING
         MVCL  TO,ADDRESS
DONEMOVE RETURN
MOVECHAR MVC   0(0,TO),0(ADDRESS)
          EJECT
*         PRINT GEN 9/73 DWS
PUT       MVC   PARM,DCBRECFM        TEST IS VARIABLE, ALS 3/74
         L     LENGTH,LEN
         LTR   LENGTH,LENGTH
         BNP   FAIL
         O     LENGTH,=X'40000000'
         L     ADDRESS,STRING
          NC    PARM,X'C0'               ALS 3/74
          CLI   PARM,X'40'               ALS 3/74
          BE    PUT#V                     ALS 3/74
          PUT  QSAM     9/73 DWS
          LR    TO,1
FETCH3    LH    WORK,DCBLRECL
         CALL  MOVE
          B    NULL TO SKIP VRBLE LENGTH STUFF 9/73 DWS
PUT#V     LA   WORK,4(,LENGTH) ADD 4 FOR RDW BYTES 9/73 DWS
          STH  WORK,DCBLRECL UPDATE LRECL BEFORE PUT 9/73 DWS
          PUT  QSAM   9/73 DWS
          LR   TO,1 HAVE PTR TO NEXT BUFFER  9/73 DWS
          STH  WORK,0(,TO) SET LENGTH IN 1ST HALF OF RDW 9/73 DWS
          MVC  2(2,TO),=H'0' SET ZEROS IN 2ND HALF OF RDW  9/73 DWS
          LA   TO,4(,TO) BUMP PTR TO START OF BUFFER 9/73 DWS
          CALL MOVE TO MOVE STRING INTO BUFFER  9/73 DWS
*         PRINT NOGEN 9/73 DWS
          EJECT
NULL      NULL
RETURN    RESULT SUCCEED
          SPACE
EOF       CALL  CLOSE
          AIF   ('&CLOSE' EQ 'LEAVE').EOF
          CALL SPLICE
.EOF      ANOP
         L     13,HSA
         L     14,RET
         SR    0,0
         RETURN                   (2,12)
FAIL      RESULT FAIL
          EJECT
* STRING DESCRIPTOR BLOCK FOR STRINGS RETURNED
          DS    0D
          SPACE
* DCB EXIT LIST AND JOB FILE CONTROL BLOCK
          DS    0F
EXITLIST DC    X'87',AL3(JFCB)
JFCB      DS    CL176
          SPACE
OPENLIST OPEN  (LISTHEAD),MF=L
          SPACE
* MODEL BLOCK IN LIST OF DCB'S AND HEADER OF THAT TWO-WAY LIST
LISTHEAD DS    0F
MODEL     DCB   DSORG=PS,MACRF=(GL,PL),EXLST=EXITLIST,EODAD=EOF
         DC    A(LISTHEAD),A(LISTHEAD)
DDNAME   DC    CL8' '
MEMBER   DC    CL8' '
FUNCNAME DC    C' '
         DC    CL7' '
          SPACE
SAVEAREA DS    18F
PARM      DS    F
          END   CINOUT
