#
/*
 */

#include "../param.h"
#include "../systm.h"
#include "../reg.h"
#include "../buf.h"
#include "../filsys.h"
#include "../user.h"
#include "../inode.h"
#include "../file.h"
#include "../conf.h"

/*
 * The fstat system call.
 */
fstat()
{
	register *fp;

	if ((fp = getf(u.u_ar0[R0])) != NULL)
		stat1(fp->f_inode, u.u_arg[0]);
}

/*
 * The stat system call.
 */
stat()
{
	register ip;
	extern uchar;

	if ((ip = namei(&uchar, 0)) != NULL) {
		stat1(ip, u.u_arg[1]);
		iput(ip);
	}
}

/*
 * The basic routine for fstat and stat:
 * get the inode and pass appropriate parts back.
 */
stat1(ip, ub)
int *ip;
{
	register i, *bp, *cp;

	iupdat(ip, &time);
	i = ip->i_number - 1;
	bp = bread(ip->i_dev, (2 + (i>>4)));
	cp = bp->b_addr + ((i&017)<<5) + 24;
	ip = &(ip->i_dev);
	for(i=0; i<14; i++) {
		suword(ub, *ip++);
		ub =+ 2;
	}
	for(i=0; i<4; i++) {
		suword(ub, *cp++);
		ub =+ 2;
	}
	brelse(bp);
}

/*
 * The dup system call.
 */
dup()
{
	register i, r, *fp;

	r = u.u_ar0[R0];
	if ((fp = getf(r)) != NULL  &&  (i = ufalloc()) >= 0) {
		u.u_ofile[i] = fp;
		fp->f_count++;
		/* ##stt 8/7/76 duplicate proto handle also */
		fp = &u.u_pfile[i];
		if (*fp != NULL)
			closef(*fp);
		if ((*fp = u.u_pfile[r]) != NULL)
			(*fp)->f_count++;
	}
}

/*
 * The mount system call (only su).
 * errors --
 * EBUSY: The file the device is to be mounted on is busy
 *	  or the device is already mounted.
 */
smount()
{
	int d;
	register *ip;
	register struct mount *mp, *smp;
	extern uchar;

	if (suser()) {
		d = getmdev();
		if(u.u_error)
			return;
		u.u_dirp = u.u_arg[1];
		if ((ip = namei(&uchar, 0)) == NULL)
			return;
		if(ip->i_count!=1 || (ip->i_mode&(IFBLK&IFCHR))!=0)
			goto out;
		smp = NULL;
		for(mp = &mount[0]; mp < &mount[NMOUNT]; mp++) {
			if(mp->m_bufp != NULL) {
				if(d == mp->m_dev)
					goto out;
			} else
			if(smp == NULL)
				smp = mp;
		}
		if(smp != NULL) {
			(*bdevsw[d.d_major].d_open)(d, !u.u_arg[2]);
			if(!u.u_error) {
				mp = bread(d, 1);
				if(u.u_error) {
					brelse(mp);
					goto out1;
				}
				smp->m_inodp = ip;
				smp->m_dev = d;
				smp->m_bufp = getblk(NODEV);
				bcopy(mp->b_addr, smp->m_bufp->b_addr, 256);
				smp = smp->m_bufp->b_addr;
				smp->s_ilock = 0;
				smp->s_flock = 0;
				smp->s_ronly = u.u_arg[2] & 1;
				brelse(mp);
				ip->i_flag =| IMOUNT;
				prele(ip);
				return;

			}
		}
out:
		u.u_error = EBUSY;
out1:
		iput(ip);
	}
}

/*
 * The umount system call (only su).
 * errors --
 * EINVAL: Can't find the device in the mount table, probably because
	   nami() or getmdev() returned garbage.
 * EBUSY: The mounted device is being used by a process.
 */
sumount()
{
	int d;
	register struct inode *ip;
	register struct mount *mp;

	if(suser()) {
		update();
		d = getmdev();
		if(u.u_error)
			return;
		for(mp = &mount[0]; mp < &mount[NMOUNT]; mp++)
			if(mp->m_bufp!=NULL && d==mp->m_dev)
				goto found;
		u.u_error = EINVAL;
		return;
	
found:
		for(ip = &inode[ll (only su).
 * errors --
 * EINVAL: Can't find the device in the mount table, probably because
	   nami() or getmdev() returned garbage.
 * EBUSY: The mounted device is being used by a process.
 */
sumount()
{
	int d;
	register struct inode *ip;
	register struct mount *mp;

	if(suser()) {
		update();
		d = getmdev();
		if(u.u_error)
			return;
		for(mp = &mount[0]; mp < &mount[NMOUNT]; mp++)
			if(mp->m_bufp!=NULL && d==mp->m_dev)
				goto found;
		u.u_error = EINVAL;
		return;
	
found:
		for(ip = &inode[ll (only su).
 * errors --
 * EINVAL: Can't find the device in the mount table, probably because
	   nami() or getmdev() returned garbage.
 * EBUSY: The mounted device is being used by a process.
 */
sumount()
{
	int d;
	register struct inode *ip;
	register struct mount *mp;

	if(suser()) {
		update();
		d = getmdev();
		if(u.u_