#
#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../proc.h"

#define	UMODE	0170000
/*#define	SCHMAG	10	/* value for scheduling shuffle */
#define	SCHMUL	4	/* ##stt new style sched algorithm */
#define	SCHDIV	5	/* ##stt ditto */
#define	PIRQ	0177772	/* address of pirq */

/*
 * clock is called straight from
 * the real time clock interrupt.
 *
 * Functions:
 *	reprime clock
 *	copy *switches to display
 *	implement callouts
 *	maintain user/system times
 *	maintain date
 *	profile
 *	tout wakeup (sys sleep)
 *	lightning bolt wakeup (every 4 sec)
 *	alarm clock signals
 *	jab the scheduler
 */
clock(dev, sp, r1, nps, r0, pc, ps)
{
	extern prd_str;
	register struct callo *p1, *p2;
	register struct proc *pp;

	/*
	 * restart clock
	 */

	*lks = 0115;

	/*
	 * display register
	 */

	display();

	/*
	 * callouts
	 * if none, just return
	 * else update first non-zero time
	 */

	if(callout[0].c_func == 0)
		goto out;
	p2 = &callout[0];
	while(p2->c_time<=0 && p2->c_func!=0)
		p2++;
	p2->c_time--;

	/*
	 * if ps is high, just return
	 */

	if((ps&0340) != 0)
		goto out;

	/*
	 * callout
	 */

	spl5();
	if(callout[0].c_time <= 0) {
		p1 = &callout[0];
		while(p1->c_func != 0 && p1->c_time <= 0) {
			(*p1->c_func)(p1->c_arg);
			p1++;
		}
		p2 = &callout[0];
		while(p2->c_func = p1->c_func) {
			p2->c_time = p1->c_time;
			p2->c_arg = p1->c_arg;
			p1++;
			p2++;
		}
	}

	/*
	 * lightning bolt time-out
	 * and time of day
	 */

out:
	if((ps&UMODE) == UMODE) {
		u.u_utime++;
		if(u.u_prof[3])
			incupc(pc, u.u_prof);
	} else
		u.u_stime++;
	pp = u.u_procp;
	if(++pp->p_cpu == 0)
		pp->p_cpu--;
	if(++lbolt >= HZ) {
		if((ps&0340) != 0)
			return;
		lbolt =- HZ;
		/* ##stt 3/2/77 use longs */
		++time;
		spl1();
		if (time == tout)
			wakeup(&tout);
		if((time.long1&03) == 0) {
			runrun++;
			wakeup(&lbolt);
			prd_str = 0;	/* reset prdev mult err chk */
		}
		for(pp = &proc[0]; pp <= maxproc; pp++)
		    /* ##stt 3/2/77 skip over zombies */
		    if (pp->p_stat && pp->p_stat != SZOMB) {
			if(pp->p_time != 127)
				pp->p_time++;
			/* ##stt new sched algorithm 11/3/76 */
			pp->p_cpu = (pp->p_cpu & 0377) * SCHMUL / SCHDIV;
			if(pp->p_pri >= PUSER)
				setpri(pp);
			/* ##stt 3/2/77 alarms */
			if (pp->p_alarm && --pp->p_alarm == 0)
				psignal(pp, SIGALA);
		    }
		if(runin!=0) {
			runin = 0;
			wakeup(&runin);
		}
		if((ps&UMODE) == UMODE) {
			u.u_ar0 = &r0;
			if(issig())
				psig();
			setpri(u.u_procp);
		}
	}
	/*
	 * every 4 tics see if there are any dh input characters to service
	 * by triggering the pirq which calls dhrint() asynchronously 
	 */

	if((lbolt&03)==0)
		PIRQ->integ =|  020000;
}

/*
 * timeout is called to arrange that
 * fun(arg) is called in tim/HZ seconds.
 * An entry is sorted into the callout
 * structure. The time in each structure
 * entry is the number of HZ's more
 * than the previous entry.
 * In this way, decrementing the
 * first entry has the effect of
 * updating all entries.
 */
timeout(fun, arg, tim)
{
	register struct callo *p1, *p2;
	register t;
	int s;

	t = tim;
	s = PS->integ;
	p1 = &callout[0];
	spl7();
	while(p1->c_func != 0 && p1->c_time <= t) {
		t =- p1->c_time;
		p1++;
	}
	p1->c_time =- t;
	p2 = p1;
	while(p2->c_func != 0) {
		p2++;
		/* ##bsb 3/2/77 check if out of callouts */
		/* always leave last slot empty */
		if (p2 >= &callout[NCALL-1])
			panic("Out of Callouts!");
	}
	while(p2 >= p1) {
		(p2+1)->c_time = p2->c_time;
		(p2+1)->c_func = p2->c_func;
		(p2+1)->c_arg = p2->c_arg;
		p2--;
	}
	p1->c_time = t;
	p1->c_func = fun;
	p1->c_arg = arg;
	PS->integ = s;
}
