#
/*
 */

/*
 *	Memory special file
 *	minor device 0 is physical memory
 *	minor device 1 is kernel memory
 *	minor device 2 is EOF/RATHOLE
 */

#include "../param.h"
#include "../user.h"
#include "../conf.h"
#include "../seg.h"
/* for def. of clist struct... */
#include "../tty.h"

/* ##stt 4/13/77 add stuff for logger device */
/* log_open flag is checked in ken/prf.c (log) */
int log_open;
struct clist log_q;

mmopen(dev)
{
	if (dev.d_minor == LOG_DEVMINOR)
		log_open = LOG_OPEN;
}

mmclose(dev)
{
	register int c;

	if (dev.d_minor == LOG_DEVMINOR) {
		log_open = 0;
		while ((c = getc(&log_q)) >= 0)
			putchar(c);
	}
}

mmread(dev)
{
	register c, bn, on;
	int a, d;

	if (dev.d_minor == LOG_DEVMINOR) {
		while (log_q.c_cc == 0)
			sleep(&log_q, LOG_PRI);
		while ((c = getc(&log_q)) >= 0 &&
		    passc(c) >= 0);
		/* if count now zero, wakeup possible writer */
		if (log_q.c_cc == 0) wakeup(&log_q);
		/* return as soon as have a message */
		return;
	}
	if(dev.d_minor == 2)
		return;
	do {
		bn = lshift(u.u_offset, -6);
		on = u.u_offset[1] & 077;
		a = UISA->r[0];
		d = UISD->r[0];
		spl7();
		UISA->r[0] = bn;
		UISD->r[0] = 077406;
		if(dev.d_minor == 1)
			UISA->r[0] = (ka6-6)->r[(bn>>7)&07] + (bn & 0177);
		c = fuibyte(on);
		UISA->r[0] = a;
		UISD->r[0] = d;
		spl0();
	} while(u.u_error==0 && passc(c)>=0);
}

mmwrite(dev)
{
	register c, bn, on;
	int a, d;

	if (dev.d_minor == LOG_DEVMINOR) {
		/* add this to log clist */
		/* but first wait until empty */
		if (u.u_count > (LOGHOG>>1)) {
			u.u_error = EINVAL;
			return;
		}
		spl7();
		while (log_q.c_cc)
			sleep(&log_q);
		putc(LOG_AUX, &log_q);
		while ((c = cpass()) >= 0)
			putc(c, &log_q);
		putc(0, &log_q);
		spl0();
		wakeup(&log_q);
		return;
	}
	if(dev.d_minor == 2) {
		c = u.u_count;
		u.u_count = 0;
		u.u_base =+ c;
		dpadd(u.u_offset, c);
		return;
	}
	for(;;) {
		bn = lshift(u.u_offset, -6);
		on = u.u_offset[1] & 077;
		if ((c=cpass())<0 || u.u_error!=0)
			break;
		a = UISA->r[0];
		d = UISD->r[0];
		spl7();
		UISA->r[0] = bn;
		UISD->r[0] = 077406;
		if(dev.d_minor == 1)
			UISA->r[0] = (ka6-6)->r[(bn>>7)&07] + (bn & 0177);
		suibyte(on, c);
		UISA->r[0] = a;
		UISD->r[0] = d;
		spl0();
	}
}
