#
/*
 *  stripped-down lp-11 driver
 */

#include "../param.h"
#include "../conf.h"
#include "../user.h"

#define LPADDR	0177514

#define	IENABLE	0100
#define	DONE	0200

#define	LPPRI	10
#define	LPLWAT	150
#define	LPHWAT	450
#define	CLOSED	0
#define	OPEN	1
#define	SLEEPING	2

struct {
	int lpsr;
	int lpbuf;
};

struct	{
	int	cc;
	char	*cf;
	char	*cl;
	int	state;
} lp11;

lpopen(dev, flag)
{
	if(flag==0) {
		u.u_error = ENXIO;
		return;
	}
	if(lp11.state != CLOSED) {
		u.u_error = EIO;
		return;
	}
	lp11.state = OPEN;
	LPADDR->lpsr =| IENABLE;
}

lpclose(dev, flag)
{
	extern lbolt;

	putc(014,&lp11);		/* force trling ff */
	spl4();
	lpint();
	spl0();
	while(lp11.cc != 0)
		sleep(&lbolt, LPPRI);
	lp11.state = CLOSED;
}

lpwrite()
{
	register c;
	extern lbolt;

	while((c = cpass()) >= 0) {
		if(lp11.cc >= LPHWAT) {
			lp11.state = SLEEPING;
			sleep(&lp11, LPPRI);
		}
		putc(c, &lp11);
	}
	spl4();
	lpint();
	spl0();
}

lpint()
{
	register c;

	while(LPADDR->lpsr & DONE && (c=getc(&lp11))>=0)
		LPADDR->lpbuf = c;
	if(lp11.cc <= LPLWAT && lp11.state==SLEEPING) {
		wakeup(&lp11);
		lp11.state = OPEN;
	}
}
