#

/*
 * DV Disk Driver
 */
#include "../param.h"
#include "../user.h"
#include "../conf.h"
#include "../buf.h"
#include "../systm.h"
#include "../st_his.h"


struct {
	int	dvcsr;
	int	dvdbr;
	int	dvmar;
	int	dvwcr;
	int	dvcbr;
	int	dvssr;
	int	dvair;
};
struct { char lbyte, hbyte; };

#define CSW	0177570
#define	DVADDR	0164000
#define	NDV	2
#define DV_SWPN	06		/* low 3 bits of swap device num */
#define DVQ_ILV	1		/* interleave for diva queue */
#define DVSW_ILV	1		/* interleave for swap device */
#define	INTLV	2		/* # of sectors skipped between optimally
				 * consecutive sectors.
				 */

struct {
	char	*nblocks;
	int	cyloff;
} dv_sizes[] {
	(198*240)-12, 197,	/*DVn0: cyl 197->0 (shy 12 blks) */
	(198*240)-12, 207,	/*DVn1: cyl 207->404 (shy 12 blks) */
	0,	0,		/*DVn2: undefinded */
	(198*240)-12, 208,	/*DVn3: cyl 208->405 (shy 12 blks) */
	0,	0,		/*DVn4: undefined */
	0,	0,		/*DVn5: undefined */
	(10*240), 207,		/*DVn6: cyl 207->198 (SWAP space) */
	240,	0,		/*DVn7: cyl 0, (for purpose of dropping the
				 * boot programs into place only!) */
};

struct {
	int	hd1;
	int	hd2;
	int	cksum;
	char	*chadr;
} dvhdr;

int lastcyl;
int	dv_unit -1;
int	intcyl;
int	dvhist;

#ifdef	HISTON
int	dvstime, dvrtime;	/* used to hold latency times */
int	lbolt;		/* used for timing */
#endif

struct	devtab	dvtab;
struct	buf	rdvbuf;

struct dvq {
	struct	buf *dv_bufp;
	int	dv_lcyl;
	char	dv_dirf;
	char	dv_nreq;
} dvq[NDV];
struct	dvq	*dv_ap;
char	dv_done;

#define	SWTUNIT	10
int	dv_nxfr;

#define	HTBCOM	000000
#define	CTBCOM	020000
#define	CNBCOM	030000
#define		INCHD	01
#define		RECAL	02
#define		RESET	020
#define		SEEK	040
#define		CLRDA	0100
#define	CHRCOM	070000
#define	CHWCOM	0130000
#define	LDSCOM	0140000
#define	CTLRST	0170000

#define	DRVRDY	04000
#define	ATTN	0400
#define	DONE	0200
#define	IENABLE	0100
#define	GO	01

#define DVLOOP 300000L	/* loop count when diva not ready */

/*
 * Use av_back to save cylinder,
 * b_resid for sector+track.
 */

#define	dvcyl	av_back
#define	dvsec	b_resid.lbyte
#define	dvhd	b_resid.hbyte

dvstrategy(abp)
struct buf *abp;
{
	register struct buf *bp;
	register char *p1, *p2;
	int f;

	bp = abp;
	p1 = &dv_sizes[bp->b_dev.d_minor&07];
	if(bp->b_dev.d_minor >= (NDV<<3) || bp->b_blkno >= p1->nblocks) {
		bp->b_flags =| B_ERROR;
		iodone(bp);
		return;
	}
#ifdef CPU70
	if (bp->b_flags&B_PHYS)	/*##stt 10/18/76 unibus map stuff */
		mapalloc(bp);
#endif
	bp->av_forw = 0;
	dvcalc(bp);
	spl5();
	p2 = &dvq[(bp->b_dev.d_minor)>>3];
	p2->dv_nreq++;
	if((p1 = p2->dv_bufp)==NULL) {
		p2->dv_bufp = bp;
	} else {
		f = p2->dv_dirf;
		for (; p2 = p1->av_forw; p1 = p2) {
			if (p1->dvcyl <= bp->dvcyl
			 && bp->dvcyl <= p2->dvcyl
			 || p1->dvcyl >= bp->dvcyl
			 && bp->dvcyl >= p2->dvcyl) {
				while(p1->dvcyl==p2->dvcyl) {
					if(p2->dvsec > p1->dvsec) {
						/*##stt 1/14/77 INTLV=>DVQ_ILV*/
						if(bp->dvsec>p1->dvsec+DVQ_ILV
						 &&bp->dvsec<p2->dvsec-DVQ_ILV)
							goto out;
					} else {
						if(bp->dvsec>p1->dvsec+DVQ_ILV
						||bp->dvsec<p2->dvsec-DVQ_ILV)
							goto out;
					}
					p1 = p2;
					if(!(p2 = p1->av_forw)) goto out;
				}
				goto out;
			}
			if(f) {
				if(p2->dvcyl < p1->dvcyl)
					if(bp->dvcyl > p1->dvcyl)
						goto out;
					else
						f = 0;
			} else {
				if(p2->dvcyl > p1->dvcyl)
					if(bp->dvcyl < p1->dvcyl)
						goto out;
					else
						f++;
			}
		}
out:
		bp->av_forw = p2;
		p1->av_forw = bp;
		/*##stt 10/18/76 try to avoid hanging on diva */
	}
	if (dvtab.d_active == 0) dvstart();
	spl0();
}

dvstart()
{
	register *rp, *hp;
	register struct buf *bp;
	int i;
	struct { struct dvq *dvqp; };
	struct { char *unsigned; };

	if ((hp = dv_ap) == NULL) {
		hp = dvq;
	} else if (dv_done) {
		dv_done = 0;
		dvtab.d_errcnt = 0;
		if ((bp = hp->dv_bufp) != NULL) {
			hp->dv_nreq--;
			hp->dv_bufp = bp->av_forw;
			if (++dv_nxfr > SWTUNIT) goto newunit;
		}
	}
	if((bp = hp->dv_bufp)==NULL) {
newunit:
		dv_nxfr = 0;
		i = NDV;
		do {
			if (--i < 0) {
				dv_ap = 0;
				dvtab.d_active = 0;
				return;
			}
			if(++(hp.dvqp) >= &dvq[NDV])
				hp = dvq;
		} while ((bp = hp->dv_bufp) == NULL);
	}
	dv_ap = hp;
#ifdef DV_DEBUG
	if((bp->b_dev.d_minor&07) == 6 &&
	   (bp->dvcyl > dv_sizes[6].cyloff ||
	   bp->dvcyl <= dv_sizes[6].cyloff - (dv_sizes[6].nblocks/240))) {
		printf("dv: cyl out of range: %d on minor %d\n",
			bp->dvcyl, bp->b_dev.d_minor);
		dvherr();
		return;
	}
#endif
	dvtab.d_active++;
	st_word =| ST_DVBUSY;	/* set bit in state word */
	rp = &DVADDR->dvcbr;
	if (dv_unit!=(bp->b_dev.d_minor>>3)) {	/* select unit */
		*rp = LDSCOM | (dv_unit = bp->b_dev.d_minor>>3);
		/*   waste time if we un-strap delay  */
	}
	i = bp->dvcyl;
	*rp++ = CNBCOM | RESET | CLRDA;	/* reset and clear */
	if (i != ~(*rp|0177000)) {	/* seek */
		DVADDR->dvcbr = CTBCOM | i;
		if (dvrdy())
			return;
		DVADDR->dvcbr = CNBCOM | SEEK | RESET;
		st_word =| ST_DVSEEK;	/* set bit in state word */
		hp = dv_ap;
		if((lastcyl = (*hp).dv_lcyl) > i)
			(*hp).dv_dirf = 0;
		else
			(*hp).dv_dirf = 1;
		(*hp).dv_lcyl = i;
		DVADDR->dvair = 1<<dv_unit;
		DVADDR->dvcsr = DONE | IENABLE;
#ifdef	HISTON
		dvstime = -lbolt;	/* ##stt-2/6/76 seek time */
#endif
		return;
	}
	*--rp = HTBCOM | bp->dvhd;	/* select head */
	if (bp->b_wcount.unsigned <= -256)	/* multi-block ? */
		*--rp = -512;
	else
		*--rp = bp->b_wcount<<1;
	hp = &dvhdr.hd2;
	*hp = 0170000 | bp->dvsec;;	/* set up header */
	*--hp = (bp->dvhd<<8) + i;
	*--rp = hp;			/* set up MAR */
	*hp++ = -(*hp++ + *hp++);	/* set up checksum */
	*hp = bp->b_addr;
	if(DVADDR->dvssr&DRVRDY && dvrdy())
		return;
	DVADDR->dvcbr = ((bp->b_flags&B_READ)? CHRCOM : CHWCOM ) |
		(bp->dvsec<<1);
	DVADDR->dvcsr = IENABLE | GO | ((bp->b_xmem & 03) << 4);
#ifdef HISTON
	dvrtime =- RSCTR->integ;	/*##stt-2/6/76 rotate time */
#endif
}

dvintr()
{
	register struct buf *bp;
	register int csr;
	register *p1;
	long int l;
	struct {int high,low;};

	if (dvtab.d_active == 0)
		return;
	bp = dv_ap->dv_bufp;
	dvtab.d_active = 0;
	st_word =& ~(ST_DVBUSY|ST_DVSEEK);	/* clear state bits */
	csr = DVADDR->dvcsr;
	DVADDR->dvcsr = DONE;
	if (csr&ATTN) {		/* seeek complete */
		DVADDR->dvair.lbyte = 0;
		if (DVADDR->dvssr > 0) {	/* error */
			deverror(bp,DVADDR->dvcsr,DVADDR->dvssr);
			DVADDR->dvcbr = CNBCOM | RECAL | RESET;
			dv_unit = -1;
			if (dvrdy())
				return;
			DVADDR->dvcbr = CTLRST;
			if (++dvtab.d_errcnt <= 10) {
				dvstart();
				return;
			}
			dvherr(); return;
		} else {
#ifdef	HISTON
/*	calculate dv seek time for histogram */
			if ((dvstime =+ lbolt)<= 0) dvstime =+ HZ;
#endif
			dvstart();
			return;
		}
	} else {	/* r/w complete */

		if (csr < 0) {	/* error */
			dvhist++;
			log(LOG_INFO, "dverr:%o %o %o %d %d %d %d %d\n",
			DVADDR->dvcsr,DVADDR->dvcbr,dv_unit,bp->dvhd,
			bp->dvsec,dv_ap->dv_lcyl,lastcyl,dvtab.d_errcnt+1);
			dv_unit = -1;
			if ((++dvtab.d_errcnt & 03) == 0) {
				DVADDR->dvcbr = CNBCOM | RECAL | RESET;
				deverror(bp,csr,DVADDR->dvssr);
				if (dvrdy())
					return;
			}
			DVADDR->dvcbr = CTLRST;
			if (dvtab.d_errcnt <= 12) {
				dvstart();
				return;
			}
			dvherr(); return;
		} else {
			bp->b_wcount =+ 256;
			if (bp->b_wcount.hibyte) {  /* more to do */
				l.high = bp->b_xmem;
				l.low = bp->b_addr;
				l =+ 512;
				bp->b_xmem = l.high;
				bp->b_addr = l.low;
				bp->b_blkno++;
				dvcalc(bp);
				dvstart();
				return;
			}
		}
	}
	bp->b_resid = DVADDR->dvwcr + 0160000;
#ifdef	HISTON
/*	calc dv rotate time for histo */
	if ((dvrtime =+ RSCTR->integ) <= 0) dvrtime =+ RSCNT;
#endif
	dv_done++;
	dvstart();
	iodone(bp);
	return;
}

dvrdy()
{
	register struct buf *bp;
	long cnt;

again:
	cnt = DVLOOP;
	do if ((DVADDR->dvssr&DRVRDY)==0) return (0);
	  while (--cnt>=0);
	bp = dv_ap->dv_bufp;
	if (((bp->b_dev^rootdev)&070) == 0) {
		printf("ROOT Diva not ready\n");
		goto again;
	}
	dvherr();
	return(1);
}

dvherr()
{
	register struct buf *bp;

	bp = dv_ap->dv_bufp;
	bp->b_flags =| B_ERROR;
	deverror(bp,DVADDR->dvcsr,DVADDR->dvssr);
	dvtab.d_errcnt = 0;
	dv_done++;
	dvstart();
	iodone(bp);
	return;
}

dvread(dev)
{

	if (dvphys(dev))
		physio(dvstrategy, &rdvbuf, dev, B_READ);
}

dvwrite(dev)
{

	if (dvphys(dev))
		physio(dvstrategy, &rdvbuf, dev, B_WRITE);
}

dvphys(dev)
{
	register c;

	c = lshift(u.u_offset, -9);
	c =+ ldiv(u.u_count+511, 512);
	if (c > dv_sizes[dev.d_minor & 07].nblocks) {
		u.u_error = ENXIO;
		return(0);
	}
	return(1);
}

dvcalc(abp)
{
	register struct buf *bp;
	register int i,j;

	bp = abp;
	j = bp->b_dev.d_minor&07;
	i = dv_sizes[j].cyloff;
	if((j&01)==0)
		i =- ldiv(bp->b_blkno, 240);
	else
		i =+ ldiv(bp->b_blkno, 240);
	bp->dvcyl = i;
	i = lrem(bp->b_blkno, 240);
	if (j == DV_SWPN) {
		j = (i%(12/(DVSW_ILV+1)))*(DVSW_ILV+1);
		i =/ 12/(DVSW_ILV+1);
	} else {
		j = (i%(12/(INTLV+1)))*(INTLV+1);
		i =/ 12/(INTLV+1);
	}
	bp->dvsec = (j =+ i/20);
	bp->dvhd = 19 - i%20;
}
