#include "/h/iobuf.h"
#include "/h/stat.h"
#include "/h/sgtty.h"

char	*helpdir	"/etc/help/";
struct	inode	statb;
struct	sgtty	sgbuf;
int	printflg;		/* -print switch given. */
int	yflag;			/* -y switch given */
int	pipec[2];
int	child;
int	fout;
int	errno;
struct	iobuf	fin;

struct	dir	{
	char	d_name[16];
};

main(argc, argv)
char **argv;
{
	register int i, j;
	int trap();

	fout = dup(1);
	if(argc == 1)
		list();
	for(i = 1; i < argc; i++) {
		if(argv[i][0] == '-') {
			switch(argv[i][1]) {
				case 'p': printflg++;
					continue;

				case 'y': yflag++;
					continue;

				default:
					printf("Illegal switch \"%s\"\n", argv[1]);
					flush();
					exit(-1);
			}
			continue;
		}
		help(argv[i]);
		if(i < argc - 1)
			printf("\n\n");
	}
	flush();
	if(child)
		trap();
}

help(fnm)
{
	register int i;
	register char *cp;

	cp = fnm;
	if(any('/', cp)) {
		flush();
		type(2, "Illegal Argument: \"");
		type(2, cp);
		type(2, "\"\n");
		return;
	}
	cp = cat(helpdir, cp);
	if((i = open(cp, 0)) == -1) {
		flush();
		type(2, "No such help topic \"");
		type(2, fnm);
		type(2, "\"\n");
		return;
	}
	if(printflg && !child) {
		pipe(pipec);
		if((child = fork()) == 0) {
			close(0);
			dup(pipec[0]);
			close(pipec[1]);
			execl("/bin/print", "print", 0);
			exit(errno);
		}
		if(child == -1)
			error("No processes!");
		signal(2, trap);
		fout = pipec[1];
	}
	fstat(i, &statb);
	cp = ctime(&statb.i_mtime);
	printf("Help Topic \"%s\"; Last Modified %.10s, %.4s\n\n",
		fnm, cp, cp+20);
	fin.b_fildes = i;
	while(i = getchar())
		if(i == '\004')
			if(printflg || yflag)
				putchar('\n');
			else {
				printf("\nMore?");
				flush();
				if(!getyes())
					break;
			}
		else
			putchar(i);
	flush();
	close(fin.b_fildes);
	fin.b_nleft = 0;
}


list()
{
	register int i, j;
	char buf[512];

	type(1, "Help is available on the following topics:\n\n");
	if((i = fork()) == 0) {
		execl("/bin/ls", "ls", "-.", helpdir, 0);
		exit(0);
	}
	if(i == -1)
		error("System too busy");
	while(wait() != i);
	if((i = open("/etc/help/help.msg", 0)) >= 0) {
		while((j = read(i, &buf, 512)) > 0)
			write(1, &buf, j);
		close(i);
	}
}


getyes()
{
	char buf[32];

	for(;;) {
		if(!read(0, &buf, 32))
			exit(0);
		if(buf[0] == 'n')
			return(0);
		return(1);
	}
}


compar(dp1, dp2)
struct dir *dp1, *dp2;
{
	register char *cp1, *cp2;
	register int j;

	cp1 = &dp1->d_name;
	cp2 = &dp2->d_name;
	while(*cp1 || *cp2)
		if(j = *cp1++ - *cp2++)
			return(j);
	return(0);
}

trap()
{
	close(pipec[1]);
	while(wait() != child);
	exit(0);
}
