#include "/h/ttynames.h"
#include "/h/cinfo.h"

char *ttyname(tn)
{
	if (ttygetb(tn) < 0) return(-1);
	return (ttn_name);
}

ttynum(name)
char *name;
{
	struct cinfo infob;
	register tn;

	if (name == 0 || *name == 0 || equal(name,"tty")) {
		return(getcinfo(-1, &infob));
	}
	for (tn = 0; ttygetb(tn) >= 0; tn++) {
		if (equal(name,ttn_name)
		    || equal(cat("tty",name),ttn_name))
			return (ttn_num);
	}
	return (-1);
}

ttyconv(dev)
{
	register tn;

	for (tn = 0; ttygetb(tn) >= 0; tn++)
		if (dev == ttn_dev)
			return(ttn_num);
	return (-1);
}

ttydev(tn)
{
	if (ttygetb(tn) < 0) return (-1);
	return(ttn_dev);
}

ttygetb(tn)
{
	register char *cp;

	if (tn < 0) return (-1);
	if (ttn_fh <= 0) {
		ttn_fh = open(TTYNAMES,0);
		if (ttn_fh < 0)
			error("ttynames open error");
		ttn_num = -1;
	}
	if (tn == ttn_num) return(0);
	seek(ttn_fh, tn*sizeof(ttn_buf), 0);
	if (read(ttn_fh, &ttn_buf, sizeof ttn_buf) < sizeof ttn_buf) {
		ttn_num = -1;
		return (-1);
	}
	ttn_num = tn;
	for (cp = ttn_buf.t_name; *cp; cp++) {
		if (*cp == ' ' || *cp == ',' || *cp == ':') {
			*cp = 0;
			break;
		}
	}
	ttn_dev.d_major = ttn_cv2(ttn_buf.t_maj);
	ttn_dev.d_minor = ttn_cv2(ttn_buf.t_min);
	return(0);
}

ttn_cv2(cp)
char *cp;
{
	register i;
	i = 0;
	if (*cp >= '0' && *cp <= '9') i = *cp-'0';
	i =* 10;
	i = i+cp[1]-'0';
	return(i);
}
