#
/*
 * written by S. Tucker Taft
 *		Harvard University Science Center
 *		Cambridge, Mass.    02138
 *
 * the file 'ush.c' is a slightly modified version of the Bell
 *  original Unix shell.
 *  All other routines were written during the Spring of 1976.
 *
 * The original Harvard Shell was written by Bruce Borden
 * during the summer of 1974.
 * The major difference between the original and this rewrite is
 * that no automatic expansion of commands is provided.
 * rather, the escape key may be used to cause expansion
 * of an unambiguous abbreviation of the same set of hsh commands.
 */

#define	INTR	2
#define	QUIT	3
#define LINSIZ 1000
#define ARGSIZ 50
#define TRESIZ 100
#define CONFSIZ 80
#define RLBSIZ 200

#define QUOTE 0200
#define FAND 1
#define FCAT 2
#define FPIN 4
#define FPOU 8
#define FPAR 16
#define FINT 32
#define FPRS 64
#define TCOM 1
#define TPAR 2
#define TFIL 3
#define TLST 4
#define DTYP 0
#define DLEF 1
#define DRIT 2
#define DFLG 3
#define DSPR 4
#define DCOM 5
#define	ENOMEM	12
#define	ENOEXEC 8
#define E2BIG	7
#define ESC 033
#define LINEDEL 'U'-'@'	/* control/u = line delete */
#define CHARDEL 0177	/* rubout = character delete */
#define DDTMODE 060000	/* esc is a terminator in this tty mode */
#define SVFILE "/save.txt"	/* where shell macros a to z are kept */
				/* (see dolarg() */
#define SVLEN 64	/* max len of macro */
#define SVME '='	/* '$=' represents login path */
#define DOLBSIZ	100	/* chars available for $0-$9 */
#define DOLCLIM 20	/* # args available for & <esc> */
#define ERREXIT 0177	/* exit code used for err() */
#define MAXSIG 15	/* highest sig in mesg[] table */

char	*dolp;
char	pidp[6];
int	ldivr;
char	**dolv;
int	dolc;
char	*promp;
char	*linep;
char	*elinep;
char	**argp;
char	**eargp;
int	*treep;
int	*treeend;
char	peekc;
char	gflg;
char	error;
char	acctf;
int	uid;
char	setintr;
char	*arginp;
int	onelflg;
struct stime {
	long proct;	/* used to hold real time (see enacct() )*/
	long cputim;
	long systim;
} timeb;

struct {
	char lobyte, hibyte;
};

char	line[LINSIZ];
char	*args[ARGSIZ];
int	trebuf[TRESIZ];
char	rlbuf[RLBSIZ];

char	cflags;
int	svhshc;
char **svargp;
char	*rlp;
char	*irlp;
char	*brlp;
char	*erlp;
char *lastesc;
char	*confp;
char	*econfp;
int	dolpeek;
int	ttmode[3];
char *terminators, *retypeptr;
char *mypath;
int svfh;
int dollast;
char *savpromp;		/* used to save promp during input diversion */
char savinp;	/* non-zero if input diverted to autostart, etc. */
char noreset;	/* non-zero if should not reset on errs */
char nlflag;
char byeflg, prepromp;
int pich;	/* global used to hold file handle for getpath */

/* use () here because initialized in hshdb.c in text space */
extern char NEWLINE();	/* upper case! */
extern char *shsrchl(), *hshsrchl();
extern int database();
extern char (*mesg[])();

int resetsh();
int byebye();
