.nh
	stty - set tty modes

Format:

	& stty [mode mode ...]

Description:

     Stty is a program to change the characteristics of your
terminal.  It allows for setting the terminal speed, line width,
special character mappings, and various delay modes.  Each "mode" is
either a mode to be set or cleared such as "xtabs" or "-xtabs" to
simulate tab expansion or not; or a mode followed by "=" and
a value, such as "speed=2400", with no spaces around the "=".

Stty with no argument will list the current terminal characteristics.

On/Off modes:
.br
\?..
On	Off	Description
.in 16
.ti 0
delay	-delay	Add delays after <return>, <line-feed>, <form-feed>, and
<vertical-tab>.  Delay is needed on most mechanical terminals,
and never needed on CRT type terminals.
As "delay" is the default, the stty listing will show only "-delay"
if appropriate.

.ti 0
tdelay	-tdelay	Add delays after <tab>s.  This usually goes along with
-xtabs.

.ti 0
xtabs	-xtabs	Under mode "xtabs", the system will output multiple
spaces to simulate tab settings of 8,16,24,... .  With "-xtabs" in
effect, the tab character will be output to the terminal.
.br
\?..
.ti 0
lcase	-lcase
.ti 0
-ucase	ucase	These two control the same internal mode... the mapping of
upper case characters to lower case.  On an upper-case only terminal,
it is necessary to be in "lcase" mode, which means that all upper case
characters are mapped into lower case as they are typed.  In this
mode, an upper case character may be entered (only necessary in the
preparation of text for printing on a full character terminal) by
preceding the character with a \\.  Thus "\\A" will enter the
machine as an upper case "A", whereas "A" will enter as a lower case "a".

.ti 0
altesc	-altesc	On most terminals, the <escape> or <alt-mode> or <select>
key generates the ascii code 33(8).  On some older terminals, the
code 175(8) is generated by the key usually labelled <alt>.  As
this code is a right squiggly bracket, it is usually not desirable to
map it into code 33(8).  If the <alt> key on your terminal doesn't
work as it should, set "altesc", and 175(8) codes will be mapped into
the proper 33(8).
.br
\?..
.ti 0
echo	-echo	Turn on/off echo of typed input.  Whenever programs
such as "alias" turn echoing off, they will turn it back on when
they exit, but every now and then your terminal may be left in no-echo
mode inadvertently.  Simply "stty echo" to restore echo.

.ti 0
ddt	-ddt
.ti 0
ppl	-ppl
.ti 0
teco	-teco	These modes are used by their associated programs, and
several others, and as in the above comment on "echo" mode,
should normally never need to be set/reset.

.in 0
There are several more bits which are controllable, for more information,
see "stty" in section I and II of the UNIX manual, as well
as the file "/h/sgtty.h" for the various bit definitions.

Other modes:
.br
\?..
.in 16
.ti 0
speed=n		Set both the input and output speeds to n where n is
one of "110", "150", "300", "1200", "2400", "9600".  There are more speeds which
stty recognizes, but not all speeds are legal on all terminals.  Check
your terminal to see what speeds it will accept !before! changing the
speed using "stty".

.ti 0
ispeed=n	Set only input speed to n.

.ti 0
ospeed=n	Set only output speed to n.

.ti 0
width=n		Set terminal width to n, where n is from 0 to 127.
If the width is set to 0, then the system will generate no automatic
carriage returns at all (this is the default).  If the width is set
to 80 (for example), then if an 81st character is about to be output,
a <carriage-return>, <new-line> is output before the
overflow character.
.br
\?..
.ti 0
normal		This mode is the "normal" mode for the terminal.  This
is the mode the terminal is set to when you log in.  If the
terminal gets completely out of whack, then "stty normal" to
restore it, but remember that this will also change the speed of the
terminal back to the default speed.

.ti 0
diablo		This mode sets the appropriate parameters for the
system-75 hytype terminal.

.ti 0
ti		This mode sets the appropriate parameters for a
terminal such as the Texas Instrument Silent 700, setting "ucase" and
"delay".
.pl 2
