#
/*
 *	Execution program of PASCAL-U compiler
 *	Version 003	05-apr-77
 *	Author : Rudolf van Bottenburg
 */
#define	SIGHUP	1
#define	SIGINTR	2
#define	SIGQUIT	3
#define	SIGKILL	9
#define	IGNORE	01
#define	TSSIZE	280
#define	IN	0
#define	OUT	1
#define	PASEXT	'p'
#define LSTEXT	'l'
#define	ISCEXT	'i'
#define	BSCEXT	'b'

char	*pass1	"/lib/ppass1",
	*pass2	"/lib/ppass2",
	*pclist	"/lib/pclist",
	*pi	"/usr/bin/pascal",
	*pc	"pc";

char	l_flag[]	"-s";

char	*tmp0, *tmp1, *tmp2;	/* intermediate files */
char	ts[TSSIZE], *tsp ts;	/* temporary strings */
int	pass1_pid, pclist_pid;	/* process id's */
int	onhup, onintr, onquit;	/* old signal values */
struct	{
	char lobyte;
	char hibyte;
	};

main(argc,argv) char **argv; {
char	c_flag, r_flag, x_flag, do_pass1, do_pass2;
register char	*argp,  ch;
int	l_desc[2], pid, status;
int	errexit();

	/* set signals */
	onhup = set_sigs(SIGHUP, errexit); onquit = set_sigs(SIGQUIT, errexit);
	onintr = set_sigs(SIGINTR, errexit);
	pc = argv[0];
	if (argc > 1 && *argv[1]=='-') { /* process flags */
		argp= *++argv; argc--;
		while ( *++argp ) {
			switch(*argp) {
				default:putchar('-');putchar(*argp);
					putchar('?');putchar('\n');break;
				case 'p': l_flag[1] = 'p'; break;
				case 'l': l_flag[1] = 'f'; break;
				case '1': do_pass1++; break;
				case '2': do_pass2++; break;
				case 'c': c_flag++; break;
				case 'r': r_flag++; break;
				case 'x': x_flag++;  break;
			}
		}
	}
	if (argc <= 1) {
		printf("Usage is: %s [flags] source.p [args]\n",pc); exit();
	}
	argp = *++argv; argc--;
	switch (ch = getsuffix(argp)) {
		case -1:	/* bad length */
			printf("%s: Bad length\n",argp); exit(-1);
		case  0:	/*no suffix */
			break;
		default:
			if (ch != PASEXT && ch != ISCEXT) {
				printf("%s: Bad suffix\n", argp); exit(-1);
			}
	}
	tmp0 = setsuffix(argp, LSTEXT, ch);
	if (c_flag == 0)
		tmp1 = setsuffix(tmp0, ISCEXT, ISCEXT);
	tmp2 = setsuffix(tmp0, BSCEXT, BSCEXT);
	if (pipe(l_desc) < 0) {
		perror("pipe"); exit();
	}
	if (do_pass2==0 || do_pass1) {
		if ((pass1_pid = fork()) < 0)
			errexit();
		if (pass1_pid == 0) { /* child for pass1 */
			reset_sigs();
			close(l_desc[IN]);
			close(IN);
			if (open(argp,0)<0) {
				perror(argp);
				exit(1);
			}
			close(OUT); dup(l_desc[OUT]); close(l_desc[OUT]);
			execl(pass1, pc,  tmp1, 0);
			perror(pass1); errexit();
		}
		if ((pclist_pid = fork()) < 0)
			errexit();
		if ( pclist_pid == 0 ) { /* error diagnostics */
			reset_sigs();
			close(l_desc[OUT]);
			close(IN); dup(l_desc[IN]); close(l_desc[IN]);
			execl(pclist, pc, l_flag, argp, 0);
			perror(pclist); errexit();
		}
		close(l_desc[IN]); close(l_desc[OUT]); 
		if (wait_for_child() | wait_for_child()) {	/* | NOT || */
			errexit();
		}
		if (c_flag)
			exit();
	}
	if (do_pass1==0 || do_pass2) {
		if ((pid=fork()) < 0)
			errexit();
		if (pid == 0) {  /*child for pass2*/
			reset_sigs();
			close(l_desc[OUT]);
			execl(pass2, pc, tmp1, tmp2, 0);
			perror(pass2); errexit();
		}
		if((pid = wait(&status)) < 0 ) {
			status = 1; perror(pc);
		}
		if (do_pass2 == 0)
			unlink(tmp1);
		if (status)
			exit(-1);
	}
	if (r_flag) {
		argv[argc] = 0; *argv-- = tmp2; *argv = pi;
		reset_sigs();
		execv(pi, argv); perror(pi); exit(-1);
	}
}

wait_for_child() { /* handle child's termination */
int	this_pid, other_pid, status;
	if ((this_pid = wait(&status)) < 0) { perror(pc); exit(-1); }
	if (this_pid == pass1_pid) {
		pass1_pid = 0; other_pid = pclist_pid;
	} else {
		pclist_pid = 0; other_pid = pass1_pid;
	}
	if (status && other_pid) kill(other_pid, SIGKILL);
	return(status);
}
/*
 * Search a pathname for a suffix
 * Returns 0 if no suffix present, -1 if length too short or too long
 */
getsuffix(pathname)
	char pathname[];
{
	register int length;
	register char *string;
	register int tchar;

	string = pathname;
	length = 0;
	while(tchar = *string++)
		if (tchar == '/')
			length = 0;
		else
			length++;
	string =- 3;
	if (length<=14 && length>2 && *string++=='.')
		return(*string);
	return(length<=12 ? 0 : -1);
}

/*
 * Copy the last component of pathname and add/replace suffix
 */
setsuffix(pathname, ch, oldch)
char pathname[];
{
	register char *string, *component;

	string = component = copy(pathname);
	while(*string)
		if (*string++ == '/')
			component = string;
	if (oldch) string[-1] = ch;
	else {
		*string++ = '.'; *string++ = ch; *string++ = 0;
		tsp = string;
	}
	return(component);
}

/*
 * Makes a copy of a string and returns a pointer to it
 */
copy(name)
	char name[];
{
	register char *otsp, *string;

	otsp = tsp;
	string = name;
	while(*tsp++ = *string++);
	return(otsp);

}
/*
** Catch signal, unless already ignored, return old value
*/
set_sigs(sig, val)
{
	register	oldsignal;

	if ((oldsignal = signal(sig, val)) & IGNORE)
		signal(sig, IGNORE);
	return(oldsignal);
}

/*
** Reset signals to their original value
*/
reset_sigs()
{
	signal(SIGHUP,onhup); signal(SIGINTR, onintr); signal(SIGQUIT, onquit);
}

/*
** error exit routine
*/
errexit()
{
	unlink(tmp0); unlink(tmp1); unlink(tmp2); exit(-1);
}
