/*
 * A clist structure is the head
 * of a linked list queue of characters.
 * The characters are stored in 4-word
 * blocks containing a link and 6 characters.
 * The routines getc and putc (m45.s or m40.s)
 * manipulate these structures.
 */
struct clist
{
	int	c_cc;		/* character count */
	char	*c_cf;		/* pointer to first block */
	char	*c_cl;		/* pointer to last block */
};

/*
 * A tty structure is needed for
 * each UNIX character device that
 * is used for normal terminal IO.
 * The routines in tty.c handle the
 * common code associated with
 * these structures.
 * The definition and device dependent
 * code is in each driver. (kl.c dc.c dh.c)
 */
struct tty
{
	struct	clist t_rawq;	/* input chars right off device */
				/* canq be no longer ... rip */
	struct	clist t_outq;	/* output list to device */
	int	t_flags;	/* mode, settable by stty call */
	int	*t_addr;	/* device address (register or startup fcn) */
	char	t_delct;	/* number of delimiters in raw q */
		/* delct slept upon & wakened for ttread synch. */
	char	t_col;		/* output column of device */
	char	t_clim;		/* column limit */
	char	t_vpos;		/* Current vertical position */
	char	t_junk;		/* filler */
	char	t_vlim;		/* lines per page limit */
	char	t_lincnt;	/* number of chars on current line */
	char	t_char;		/* Pending output delay */
	int	t_state;	/* internal state, not visible externally */
	char	*t_beglin;	/* pointer to beginning of line */
	int	t_speeds;	/* output+input line speed */
	int	t_dev;		/* major, minor of this tty */
};

char partab[];			/* ASCII table: parity, character class */

#define	TTIPRI	10
#define	TTOPRI	20



/******* new tty character codes *******/
#define CQUIT	002		/* control - b */
#define CINTR	003		/* control - c */
#define CEOT	004		/* control - d */
#define CKILL	025		/* control - u */
#define CERASE	0177		/* rubout */
#define CSWTOP	017		/* control - o (^o) */
#define CRETYPE	022		/* control - r (^r) */
#define CHALTOP	023		/* control - s (^s) */
#define CALTOLD	0175		/* old style alt mode */
#define CALTNEW	033		/* new style alt mode */
#define CBELL	07		/* bell */

/* limits */
#define TTLOWAT		32
#define	TTHIWAT		96
#define	TTYHOG	127

/* modes */
#define NODELAY	01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define ALTESC	0400
#define NTDELAY	010000
#define PPL	020000
#define TECO	040000
/* inhibit slash escaping (for ecl) */
#define NOSLASH	0100000
#define PPLPOS	13
#define ILEGLMSK 0300	/* ****change as needed ****/


/* Hardware bits */
#define	DONE	0200
#define	IENABLE	0100

/* Internal state bits */
#define	TIMEOUT	01		/* Delay timeout in progress */
#define	WOPEN	02		/* Waiting for open to complete */
#define	ISOPEN	04		/* Device is open */
#define	SSTART	010		/* Has special start routine at addr */
#define	CARR_ON	020		/* Software copy of carrier-present */
#define	BUSY	040		/* Output in progress */
#define OPSUPRS	0100		/* Ouput being suppressed (^o) */
#define BKSLF	0200		/* Rubout sequence indicator */
#define HALTOP	0400		/* Output stoped (^s) */
#define SUSPEND	01000		/* Follow bit for HALTOP */
/*#define	READING	01000		/* Half-duplex Read state */
#define	SLASHS	02000		/* \ quote char seen */
#define ASLEEP	04000		/* Process asleep on high water */
#define HUPCL	010000		/* Force a hangup on the DM line */
