#
/*
 * getty -- adapt to terminal speed on dialup, and call login
 */

/*
 * tty flags
 */
#define	HUPCL 01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	ANYP	0300

/*
 * Delay algorithms
 */
#define	CR1	010000
#define	CR2	020000
#define	CR3	030000
#define	NL1	000400
#define	NL2	001000
#define	NL3	001400
#define	TAB1	002000
#define	TAB2	004000
#define	TAB3	006000
#define	FF1	040000
#define BS1	0100000

#define	ERASE	'#'
#define	KILL	'@'

/*
 * speeds
 */
#define B75	2
#define	B110	3
#define B134	4
#define	B150	5
#define B200	6
#define	B300	7
#define B600	8
#define B1200	9
#define B1800	10
#define B2400	11
#define B4800	12
#define	B9600	13
#define B0001	14
#define B0002	15

#define	SIGINT	2
#define	SIGQIT	3


struct	sgtty {
	char	sgispd, sgospd;
	char	sgerase, sgkill;
	int	sgflag;
} tmode;

struct	tab {
	int	tname;		/* this table name */
	int	nname;		/* successor table name */
	int	iflags;		/* initial flags */
	int	fflags;		/* final flags */
	int	ispeed;		/* input speed */
	int	ospeed;		/* output speed */
	char	*erase;		/* string to erase screen */
} itab[] {


/* table '-' -- Console TTY 300 baud */
	'-', '-',
	ANYP+RAW+CR1+CRMOD+XTABS, ANYP+ECHO+CRMOD+XTABS+LCASE+CR1,
	B300, B300,
	"\r\n\n\n",

/* table '1' -- Silent 700 with 64 char. ASCII */
	'1','1',
	ANYP+RAW+CR2+CRMOD+XTABS, ANYP+ECHO+CRMOD+XTABS+CR2+LCASE,
	B300, B300,
	"\r\n\n\n",

/* table '2' -- 4800 baud Superbee */
	'2', '2',
	ANYP+RAW+CRMOD+XTABS, ANYP+XTABS+ECHO+CRMOD+BS1+TAB3,
	B4800, B4800,
	"\033E\000\000\037",

/* table '3' -- T.I. Silent 700 with full ASCII  */

	'3','3',
	ANYP+RAW+CR2+CRMOD+XTABS,ANYP+ECHO+CRMOD+XTABS+CR2+BS1+TAB3,
	B300, B300,
	"\r\n\n",

/* table '4' -- 9600 baud Tektronix 4010  */

	'4','4',
	ANYP+RAW+NL1+CRMOD+FF1,ANYP+ECHO+CRMOD+XTABS+LCASE+FF1,
	B9600, B9600,
	"\n\n\n\n",		/* used to clear screen */
				/* but it was bad for the tube */

/* table '5' -- 1200 baud H.P.  */

	'5','5',
	ANYP+RAW+CRMOD, ANYP+ECHO+CRMOD+XTABS,
	B1200, B1200,
	"\033H\033J\0\0\0\0\0\n\n",

/* table '6' -- 1200 baud Lear Sigler */

	'6','6',
	ANYP+RAW+CRMOD, ANYP+ECHO+CRMOD+XTABS,
	B1200, B1200,
	"\032\0\0\0\0\0\n\n",

/* table '7' -- 9600 baud Lear Sigler */

	'7','7',
	ANYP+RAW+CRMOD, ANYP+ECHO+CRMOD+XTABS,
	B9600, B9600,
	"\032\0\0\0\0\0\n\n",

/* table '8' -- 300 baud Diablo 1620   */

	'8','8',
	ANYP+RAW+CRMOD+XTABS+FF1,ANYP+ECHO+CRMOD+XTABS+FF1,
	B300, B300,
	"\014\n\n",
};

#define	NITAB	sizeof itab/sizeof itab[0]

char	name[16];
int	crmod;
int	upper;
int	lower;

main(argc, argv)
char **argv;
{
	register struct tab *tabp;
	register tname;

/*
	signal(SIGINT, 1);
	signal(SIGQIT, 0);
*/
	tname = '0';
	if (argc > 1)
		tname = *argv[1];
	for (;;) {
		for(tabp = itab; tabp < &itab[NITAB]; tabp++)
			if(tabp->tname == tname)
				break;
		if(tabp >= &itab[NITAB])
			tabp = itab;
		tmode.sgispd = tabp->ispeed;
		tmode.sgospd = tabp->ospeed;
		tmode.sgflag = tabp->iflags;
		stty(0, &tmode);
		puts(tabp->erase);
		name[0] = 0;
		if(tabp->tname == tabp->nname ||getname()) {
			tmode.sgerase = ERASE;
			tmode.sgkill = KILL;
			tmode.sgflag = tabp->fflags;
			if(crmod)
				tmode.sgflag =| CRMOD;
			if(upper)
				tmode.sgflag =| LCASE;
			if(lower)
				tmode.sgflag =& ~LCASE;
			stty(0, &tmode);
			execl("/bin/login", "login", name, 0);
			exit(1);
		}
		tname = tabp->nname;
	}
}

getname()
{
	register char *np;
	register c;
	static cs;

	crmod = 0;
	upper = 0;
	lower = 0;
	np = name;
	do {
		if (read(0, &cs, 1) <= 0)
			exit(0);
		if ((c = cs&0177) == 0)
			return(0);
		write(1, &cs, 1);
		if (c>='a' && c <='z')
			lower++;
		else if (c>='A' && c<='Z') {
			upper++;
			c =+ 'a'-'A';
		} else if (c==ERASE) {
			if (np > name)
				np--;
			continue;
		} else if (c==KILL) {
			np = name;
			continue;
		}
		*np++ = c;
	} while (c!='\n' && c!='\r' && np <= &name[16]);
	*--np = 0;
	if (c == '\r') {
		write(1, "\n", 1);
		crmod++;
	} else
		write(1, "\r", 1);
	return(1);
}

puts(as)
char *as;
{
	register char *s;

	s = as;
	while (*s)
		write(1, s++, 1);
}
