/*
 *	Break file into records
 *
 *	Default conditions:
 *		Reads from standard input, writes to standard output.
 *		Input is textual...break on word
 *		Record delimiter will be newline
 *		Output records will be >= 60 characters long
 *		Input newlines will take precedence over size parameter
 *	Option flags:
 *		-s c	size of records should be c.
 *		-d x	record delimiter should be x.
 *		-t	non-textual...break on character
 *		-n	override newlines (create fixed length records)
 *		-f y	send output to file y? (y plus a digit) instead of standard output
 *				Up to 9 files as necessary will be created (32K chars max each file)
 */
	int b;
main(argc,argv)
	int argc;
	char **argv;
{
	char *buf[512];
	char c;
	int i;
	int s;
	int f;
	char *fn;
	int fd;
	char d;
	int l;
	int	fflg;
	int	rflg;
	int	tflg;
	int	nflg;
	tflg = nflg = 0;
	f = 60000;		/* set default file size */
	s = 60;			/* set default record size */
	d = '\n';		/* set default delimiter */
	while (--argc > 0 && **++argv == '-') {
		switch (*++*argv) {
		case 's':
			s = atoi(*++argv);
			argc--;
			break;
		case 'd':
			d = **++argv;
			break;
		case 't':
			tflg++;
			break;
		case 'n':
			nflg++;
			break;
		case 'f':
			fn = *++argv;
			argc--;
			fflg++;
			rflg++;
			break;
		}
	}
	dup(1);
	fd = 3;
	i = 0;
	while(fn[++i]);
	l = i;
	fn[l] = '0';
	fn[l+1] = '\0';
	for (;;){
		if((fflg > 0) && (rflg > 0)) {
			close(fd);
			b = 0;
			rflg = 0;
			if(++fn[l] > '9') {
				write(2,"\nfile too large",15);
				return;
			}
			if ((fd = creat(fn,0666)) < 0) {
				write(2,"\ncannot open file",17);
				return;
			}
		}
		for(i=0;i<s;i++) {
			if((c=getchar()) == '\0') {
				write(fd,&d,1);
				return;
			}
			write(fd,&c,1);
			if(fflg)
				b++;
			if(!nflg)
				if (c == '\n')
					goto out;
		}
		if(!tflg) {
			while (c != ' ') {
				if((c=getchar()) == '\0')
					break;
				write(fd,&c,1);
				if(fflg)
					b++;
			}
		}
		write(fd,&d,1);
		if(fflg)
			if(b++ < f)
			{
				printf("\n\n%d=b, %d=f\n",b,f);
				rflg++;
			}
out:;
	}
}
