#

/*
 *	dog [-pgsize] [command [arguments] ]
 *
 *	executes the command, pausing after every pgsize-1
 *	lines of standard output.
 *	If the command is not found, then the command and
 *	its arguments are taken to be files that are meant
 *	to be 'cat'ed to the terminal.  Thus, dog can be
 *	used instead of cat.
 *	If there are no arguments, dog reads from standard
 *	input; it can therefore be used as a filter.
 *	Default is pgsize=24.
 *
 *	Written 6/77 by Steve Eisen.
 */

#define DEFAULT 24

char	*args[100];
char	string[10000];

main(argc, argv)
char *argv[];  {
	register len, count;
	register char *p;
	int	i, fildes[2];
	char	**argp, *strp, c;

	if (argc > 1 && argv[1][0] == '-')  {
		len = atoi(&argv[1][1]);
		argc--;
		argv++;
	}
	else	len = DEFAULT;
	if (argc < 2) goto nargs;
	pipe(fildes);
	if (fork() == 0)  {
		close(1);
		dup(fildes[1]);
		close(fildes[0]);
		close(fildes[1]);
		argc--;
		argv++;
		argp = &args[1];
		strp = string;
		for (i=0; i<9; i++)
			*strp++ = "/usr/bin/"[i];
		for (i=0; i<argc; i++)  {
			*argp++ = strp;
			p = *argv++;
			while (*strp++ = *p++);
		}
		*argp = 0;
		execv(string+9, &args[1]);
		execv(string+4, &args[1]);
		execv(string, &args[1]);
		args[0] = "cat";
		execv("/bin/cat", args);
		puts("/bin/cat: not found");
	}
	close(0);
	dup(fildes[0]);
	close(fildes[0]);
	close(fildes[1]);
nargs:	for (;;)  {
		for (count=0; count<len-1; count++)
			while ((c = putchar(getchar())) != '\n')
				if (c == 0) exit();
		dup(1);
		close(1);
		dup(2);
		putchar(':');
		close(1);
		dup(3);
		close(3);
		do  {
			read(2, &c, 1);
		}  while (c != '\n');
	}
}

puts(as)
char *as;  {
	register char *sp;

	sp = as;
	while (*sp)
		putchar(*sp++);
	putchar('\n');
}
