//	Print ARchive Directory (PARD)
//		pard archive-name
//
//		Gerry Barksdale (Nov 1975)
struct header {
	char name[8];	//file name
	int	time[2];	//modification time
	char uid;	//user ID
	char mode;
	int	size;
} h;
char *ctime();
char *ctp;
int	global, index;
int magic,textsize,datasize,bsssize,symsize,entry,xxxx,flag;
int flags,uflag,tflag,dflag,bflag;
char sname[8];
int stype, svalue;
int	file, seekflag;
main(argc,argv)
char **argv;
{
	register int c;
	if(argc < 2) {
		printf("Usage: pard archive.name\n");
		return;
	}
	argv++;
	if(**argv == '-') {
		while(c = *++*argv)
			switch(c) {
			case 'u':	uflag++;
						break;
			case 't':	tflag++;
						break;
			case 'd':	dflag++;
						break;
			case 'b':	bflag++;
			}
		argv++;
		argc--;
	}
	flags = uflag+tflag+dflag+bflag;
	if ((file=open(*argv,0)) < 0) {
		printf("Archive %s does not exist\n",*argv);
		return;
	}
	read(file,&h.size,2);
	if(h.size != 0177555) {	//check for magic number
		printf("%s is not an archive\n",*argv);
		return;
	}
	argc =- 2;
	global = (argc?0:1);
	argv++;
	index = 0;
	while(read(file,h.name,16) == 16) {	//header size
		index++;
		seekflag = 1;
		if(global) {
			printar();
		} else if(argc && equal(h.name, *argv)) {
			printar();
			argv++;
			seek(file,2,0);
			index = 0;
			if(--argc == 0)
				break;
			continue;
		}
		if(seekflag)
			seek(file,((h.size+1)&(-2)),1);	//size could be odd
	}
}
equal(as1, as2)
char *as1, *as2;
{
	register char *s1, *s2;

	s1 = as1;
	s2 = as2;
	while(*s1++ == *s2)
		if(s1 > as1+7 || *s2++ == '\0')
			return(1);
	return(0);
}
printar() {
		printf("%2d ",index);
		printf("%-8.8s%6l ",h.name, h.size);
		printf("%3d ",h.uid);
		ctp = ctime(h.time) +4;
		printf("%12.12s", ctp);
		ctp =+ 18;
		printf(" %s", ctp);
		if(flags)
			printsym();
		else
			seek(file,((h.size+1)&(-2)),1);	//size could be odd
		seekflag = 0;
}
printsym() {
	int i, found;

	read(file,&magic,16);
	if(!flag)
		seek(file,(textsize+datasize)<<1,1);
	else
		seek(file,(textsize+datasize),1);
	i = 0;
	for(;symsize > 0;symsize =- 12) {
		found = 0;
		read(file,sname,12);
		switch (stype) {

		case 040:
			if(uflag && (found = ++i))
				printf("  %-8.8s u",sname);
			break;
		case 042:
			if(tflag && (found = ++i))
				printf("  %-8.8s t",sname);
			break;
		case 043:
			if(dflag && (found = ++i))
				printf("  %-8.8s d",sname);
			break;
		case 044:
			if(bflag && (found = ++i))
				printf("  %-8.8s b",sname);
			break;
		}
		if(found && i%6 == 0)
			printf("\n");
	}
	if(i && i%6)
		printf("\n");
}
