#
// change access to a file
//	Bill Allen
//		Naval Postgraduate School
//			May, 1975


int mode,mask,i,d;
char a,*p;
int buff[18];			//current status of the file

main(argc,argv)
char **argv;
{

	if(argc<=2) {
		printf("usage: access [-odigit] [-gdigit] [-pdigit] [-adigit] file ...\n");
		exit();
	}

	for(i=1; i<argc; i++) {
		if(*argv[i] == '-') {	//mode flag
			p = argv[i];
			a = *++p;	//mode type
			d = *++p - '0';	//new access mode
			if(d<0 || d>7){
				printf("illegal access mode\n");
				exit();
			}

			switch(a) {

			case 'o':		//owner
				mode =| (d<<6);
				mask =| (7<<6);
				break;

			case 'g':	//group
				mode =| (d<<3);
				mask =| (7<<3);
				break;

			case 'p':	//public
				mode =| d;
				mask =| 7;
				break;

			case 'a':	//all
				mode = d|(d<<3)|(d<<6);
				mask = 0777;
				break;

			default:
				printf("illegal access type\n");
				exit();
			}
		}
		else {
			if(stat(argv[i],buff)<0) {
				printf("no such file: %s\n", argv[i]);
				break;
			}
			d = mode | ((buff[2])&~mask);

			if(chmod(argv[i],d)<0)
				printf("cant change mode: %s\n",argv[i]);
		}
	}
}
