#define pop struct _pop

/* the structure which describes
 * break characters.
 * Each break character has
 * an associated action.
 */
#define NBREAKS	4
struct _brk {
	char brkch;
	int (*brkact)();
};



/* the structure describing a pop.
 * If ch is zero, then the structure
 * (and the associated descriptor) is unused.
 */
pop {
	char ch;	/* current horizontal (ie character) position */
	char cv;	/* current vertical (ie line) position */
	char hmin;	/* left-most character position on screen */
	char hmax;	/* right-most character position on screen */
	char vmin;	/* top line of screen for this pop */
	char vmax;	/* bottom line of screen for this pop */
	char mode;	/* PAGE, ROLL, ITT etc */
	char tabset;	/* 0 indicates no expansion, else length of tabs */
	struct _brk brk[NBREAKS];	/* for break chars */
};

/* Number of pops allowed */
#define NPOPS	16

/* pop modes */
#define ECHO	01
#define ITT	02
#define LBREAK	04
#define PAGE	010
#define ROLL	020


/* SCREEN SIZE PARAMETERS */
#define NLINES	18		/* number of lines on your vdu */
#define NCHARS	80		/* number of characters on a line */


/* POP character classes */
#define ONE	1		/* chars that write a character on the
				 * screen, and then move the cursor one
				 * position to the right.
				 */
#define NL	2		/* newline character */
#define IGN	3		/* chars that these routines ignore */
#define CR	4		/* fairly useless but carriage-return */
#define TAB	5		/* tab character */
#define BELL	7		/* people like bleeps */

/* the following two characters are included
 * so that we can do local editing.
 * RIGHT moves the cursor one position
 * to the right without writing a char. on the screen.
 * LEFT moves it left one position.
 * To set up the chars you wish to
 * use, see char ctab[] in pmain.c.
 * The selected chars. should not have any
 * effect on the screen cursor when echoed
 * by tty.c.
 */
#define RIGHT	8
#define LEFT	9

/* char constants */
#define SPACE	' '
#define CLEAR	12		/* char must be of class IGN */
