#include	"pop.h"

/* Called by user functions.
 * Sets up a break for
 * character c in popid.
 *
 * Action == 0: pexit
 * Action == odd: reset so that cc is not break char.
 * Else, address of function assumed for action.
 */

extern pexit();

pbreak(popid, c, action)
char c;
{
register pop *p;
register struct _brk *b;
register m;

	if ((c == '\0') || ((p = do_get(popid)) == -1))
		return;

	/* see if this char has been used before */
	m = 0;
	for (b = p->brk; b < &p->brk[NBREAKS]; b++)
		if (b->brkch == c) {
			m++;
			break;
		}

	if (action & 1) {	/* set back to no break */
		if (m)
			b->brkch = 0;
		return;
	}

	/* If no entry for this character yet
	 * then see if there is a slot free.
	 */

	if (m == 0) {
		for (b = p->brk; b < &p->brk[NBREAKS]; b++)
			if (b->brkch == '\0') {
				m++;
				break;
			}
		if (m == 0)	/* no more slots left */
			return;
		b->brkch = c;
	}

	if ((b->brkact = action) == 0)
		b->brkact = &pexit;
}
