/* The following char definitions for
 * moving the cursor are inconsistent
 * with those for local editing but
 * correspond to the characters sent
 * by the 4 arrowed function keys
 * on our modified ITT 3210s.
 */
#define RUBOUT	0177
#define UP	033
#define DOWN	'\n'
#define LEFT	010
#define RIGHT	' '
#define SEND	'.'

#define ECHO	01
#define ROLL	020

struct menu {
	char *mstring;
	int mpad[2];
};

struct mdesc {
	int hmin;
	int vmin;
	int nlines;
	int ncols;
	int colwidth;
};

extern popout;

/* Sets up the menu lists pointed to by m in a new pop.
 * 
 * hmin : as for popen
 * vmin : as for popen
 * nlines : is number of lines in pop
 * ncols : is number of columns wanted
 * colwidth : is width of each column
 *
 * -1 returned if cannot open new pop, else pop descriptor.
 *
 * If pop is full before all menu items displayed,
 * then a normal return will ensue.
 */
msetup(m,md)
struct menu **m;
struct mdesc *md;
{
struct {
	int h1,h2,v1,v2;
} sp;

register struct menu *p, **sm;
register popd;
int popsave, n;
int colc, h, v;

	sp.v2 = md->vmin + md->nlines - 1;
	sp.h2 = md->hmin + (md->ncols*md->colwidth) -1;
	sp.h1 = md->hmin;
	sp.v1 = md->vmin;
	if ((popd = popen(&sp)) == -1)
		return(-1);
	n = pgmode(popd);
	n =& ~ECHO;
	n =& ~ROLL;
	psmode(popd,n);
	popsave = popout;
	pselect(popd);
	h = v = colc = 0;

	while (p = *m++)
		while (p->mstring) {
			if (*(p->mstring) != '\0') {
				pmove(popd,h,v);
				pprintf("%s",p->mstring);
			}
			p++;
			if (++v >= md->nlines) {
				v = 0;
				if (++colc >= md->ncols) {
					phome(popd);
					pselect(popsave);
					return(popd);
				}
				h =+ md->colwidth;
			}
		}

	phome(popd);
	pselect(popsave);
	return(popd);
}



/* Select a menu item from those described by m.
 * popid is the pop descriptor of the pop in which the
 * menu was set up by msetup.
 * md is the menu descriptor block pointer.
 *
 * The address of the menu item selected is returned.
 * 0 is returned if athe selected position
 * does not correspond to a displayed menu item.
 */
mselect(popid,m,md)
struct menu **m;
struct mdesc *md;
{
register struct menu *p;
struct {
	int ch;
	int cv;
} hv;
register v, colc;
int vmax, colmax;
int popsave, n;

	popsave = popout;
	if (pselect(popid) == -1)
		return(-1);

	pwhere(popid,&hv);
	colc = hv.ch / md->colwidth;
	colmax = md->ncols-1;
	v = hv.cv;
	vmax = md->nlines-1;

	for(;;) {

	switch (pread()) {
	case UP:
		if (v != 0) {
			v--;
			pvseek(popid,1,-1);
		}
		else {
			v = vmax;
			pvseek(popid,2,0);
		}
		continue;

	case DOWN:
		if (v != vmax) {
			v++;
			pvseek(popid,1,1);
		}
		else {
			v = 0;
			pvseek(popid,0,0);
		}
		continue;

	case LEFT:
		if (colc != 0) {
			colc--;
			phseek(popid,1,-(md->colwidth));
		}
		else {
			colc = colmax;
			phseek(popid,0,colc*md->colwidth);
		}
		continue;

	case RIGHT:
		if (colc != colmax) {
			colc++;
			phseek(popid,1,md->colwidth);
		}
		else {
			colc = 0;
			phseek(popid,0,0);
		}
		continue;

	case SEND:
		n = colc * md->nlines;
		n =+ v;
		p = *m++;
		do {
			while (p->mstring == 0)
				if ((p = *m++) == 0) {
					pselect(popsave);
					return(0);
				}
			if (n-- == 0)
				break;
		}
		while (p++);
		pselect(popsave);
		return(p);
	}
	}
}
