#
#include "../param.h"
#include "../user.h"
#include "../systm.h"
#include "../proc.h"
#include "../text.h"
#include "../inode.h"
#include "../seg.h"

#define	CLOCK1	0177546
#define	CLOCK2	0172540
/*
 * Icode is the octal bootstrap
 * program executed in user mode
 * to bring up the system.
 */
int	icode[]
{
	0104413,	/* sys exec; init; initp */
	0000014,
	0000010,
	0000777,	/* br . */
	0000014,	/* initp: init; 0 */
	0000000,
	0062457,	/* init: </etc/init\0> */
	0061564,
	0064457,
	0064556,
	0000164,
};

/*
 * Initialization code.
 * Called from m40.s or m45.s as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	find which clock is configured
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 *
 * panic: no clock -- neither clock responds
 * loop at loc 6 in user mode -- /etc/init
 *	cannot be executed.
 */
main()
{
	extern schar;
	register i, *p;

	/*
	 * zero and free all of core
	 */

	updlock = 0;
	i = *ka6 + USIZE;
	UISD->r[0] = 077406;
	for(;;) {
		UISA->r[0] = i;
		if(fuibyte(0) < 0)
			break;
		clearseg(i);
		maxmem++;
		mfree(coremap, 1, i);
		i++;
	}
	if(cputype == 70)
	for(i=0; i<62; i=+2) {
		UBMAP->r[i] = i<<12;
		UBMAP->r[i+1] = 0;
	}
	printf("mem = %l\n", maxmem*5/16);

/*	nobody will object, i think. george rolf, 19 november, 1975.
	printf("RESTRICTED RIGHTS\n\n");
	printf("Use, duplication or disclosure is subject to\n");
	printf("restrictions stated in Contract with Western\n");
	printf("Electric Company, Inc.\n");
*/

	maxmem = min(maxmem, MAXMEM);
	mfree(swapmap, nswap, swplo);

	/*
	 * determine clock
	 */

	UISA->r[7] = ka6[1]; /* io segment */
	UISD->r[7] = 077406;
	lks = CLOCK1;
	if(fuiword(lks) == -1) {
		lks = CLOCK2;
		if(fuiword(lks) == -1)
			panic("no clock");
	}

	/*
	 * set up system process
	 */

	proc[0].p_addr = *ka6;
	proc[0].p_size = USIZE;
	proc[0].p_stat = SRUN;
	proc[0].p_flag =| SLOAD|SSYS;
	u.u_procp = &proc[0];

	/*
	 * set up 'known' i-nodes
	 */

	*lks = 0115;
	cinit();
	binit();
	iinit();
	rootdir = iget(rootdev, ROOTINO);
	rootdir->i_flag =& ~ILOCK;
	u.u_cdir = iget(rootdev, ROOTINO);
	u.u_cdir->i_flag =& ~ILOCK;

	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

	if(newproc()) {
		expand(USIZE+1);
		/* next line changed; doc # 13-IV ********/
		esturdo( 1 );
		copyout(icode, 0, sizeof icode);
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		return;
	}
	sched();
}

/*
 * Load the user hardware segmentation
 * registers from the software prototype.
 * The software registers must have
 * been setup prior by estabur.
 *
 * routine changed; doc # 13-VI.	********
 */
sureg()
{
	register *up, *rp, a;

	up = &u.u_uisd[16];
	rp = &UISD->r[16];
	if(cputype == 40) {
		up =- 8;
		rp =- 8;
	}
	while(rp > &UISD->r[0]) {
		/* next line changed; doc # 14 *********/
		*--rp = *--up & DM;
		if((*up & WO) == 0)
			a = u.u_procp->p_textp->x_caddr;
		/* 2 lines inserted; doc # 14 *********/
		else if(*up & SD)
			a = u.u_procp->p_sdap->x_caddr;
		else
			a = u.u_procp->p_addr;
		rp[(UISA-UISD)/2] = a + up[&u.u_uisa[0] - &u.u_uisd[0]];
	}
}

/*
 * two routines added; doc # 13-IV	********
 */
esturst()
{
	/* next line changed; doc # 14 *********/
	return( estabur(u.u_tsize,u.u_dsize,u.u_sdsize,u.u_sdpage,u.u_ssize,u.u_sep) );
}

esturdo(d)
{
	/* next line changed; doc # 14 *********/
	return( estabur(0,d,0,0,0,0) );
}

/*
 * Following routine and globals added; doc # 13-V.	********
 * Globals used to communicate between setsr and estabur.
 */
int ma_a;
int *ma_ap, *ma_dp;

/*
 * Routine used by estabur to set the prototype relocation
 * registers starting at ma_ap/ma_dp for a length of l, start-
 * ing at ma_a. The latter two are in 32-word units.
 */
setsr(l,b)
{
	register ll;

	ll = l;
	while( ll >= 128 ) {
		*ma_dp++ = (127<<8)|b;
		*ma_ap++ = ma_a;
		ma_a =+ 128;
		ll =- 128;
	}
	if( ll ) {
		*ma_dp++ = ((ll-1)<<8)|b;
		*ma_ap++ = ma_a;
		ma_a =+ ll;
	}
}

/*
 * Set up software prototype segmentation
 * registers to implement the 3 pseudo
 * text,data,stack segment sizes passed
 * as arguments.
 * The argument sep specifies if the
 * text and data+stack segments are to
 * be separated.
 *
 * Routine changed to use setsr; doc # 13-V.	********
 */
/* next line changed; doc # 14 *********/
estabur(nt, nd, nsd, sp, ns, sep)
{
	register a;

	a = nseg(nd);
	if(sep) {
		if(cputype == 40)
			goto err;
		if(nseg(nt) > 8 )
			goto err;
	} else
		a =+ nseg(nt);
	/* 4 lines inserted; doc # 14 *********/
	if(nsd) {
		if((a>sp) || ((sp+nseg(nsd)+nseg(ns)) > 8))
			goto err;
	} else {
		if( (a+nseg(ns)) > 8 )
			goto err;
	}
	/* next line changed; doc # 14 *********/
	if(nt+nd+nsd+ns+USIZE > maxmem)
		goto err;
	ma_a = 0;
	ma_ap = &u.u_uisa[0];
	ma_dp = &u.u_uisd[0];
	setsr(nt,RO);
	if(sep)
	while(ma_ap < &u.u_uisa[8]) {
		*ma_ap++ = 0;
		*ma_dp++ = 0;
	}
	ma_a = USIZE;
	setsr(nd,RW);
	while(ma_ap < &u.u_uisa[8]) {
		*ma_dp++ = 0;
		*ma_ap++ = 0;
	}
	if(sep)
	while(ma_ap < &u.u_uisa[16]) {
		*ma_dp++ = 0;
		*ma_ap++ = 0;
	}
	ma_a =+ ns;
	while(ns >= 128) {
		ma_a =- 128;
		ns =- 128;
		*--ma_dp = (127<<8) | RW;
		*--ma_ap = ma_a;
	}
	if(ns) {
		*--ma_dp = ((128-ns)<<8) | RW | ED;
		*--ma_ap = ma_a-128;
	}
	/* 5 lines inserted; doc # 14 *********/
	ma_a = 0;
	a = (sep ? sp+8 : sp);
	ma_ap = &u.u_uisa[a];
	ma_dp = &u.u_uisd[a];
	setsr(nsd, RW|SD);
	if(!sep) {
		ma_ap = &u.u_uisa[0];
		ma_dp = &u.u_uisa[8];
		while(ma_ap < &u.u_uisa[8])
			*ma_dp++ = *ma_ap++;
		ma_ap = &u.u_uisd[0];
		ma_dp = &u.u_uisd[8];
		while(ma_ap < &u.u_uisd[8])
			*ma_dp++ = *ma_ap++;
	}
	sureg();
	return(0);

err:
	u.u_error = ENOMEM;
	return(-1);
}

/*
 * Return the arg/128 rounded up.
 */
nseg(n)
{

	return((n+127)>>7);
}

/*
 * routine added; doc # 13-VII	********
 *
 * verify that buffer b,l in user space is valid and
 * contiguous in physical core.
 */
verbuf(b,l)
char *b, *l;
{
	register char *bb, *end, *x;

	bb = b;
	/* verify wraparound */
	if( bb >= bb+l )  return(1);
	x = 0;
	end = ((bb+l-1)>>6) & 01777;
	bb = (bb>>6) & 01777;
	if( !u.u_sep ) {
		x = (u.u_tsize+0177) & ~0177;
		if( bb < x )  return(1);
	}
	/* check data area */
	if( end < x + u.u_dsize )  return(0);
	/* 6 lines inserted; doc # 14 *********/
	/* check shared data area */
	if(u.u_sdsize) {
		x = u.u_sdpage<<7;
		if((bb>=x) && (end < x+u.u_sdsize))
			return(0);
	}
	/* check stack area */
	if( bb >= 1024 - u.u_ssize )  return(0);
	return(1);
}

/*
 * Routine added; doc # 20		**********
 */
sphysa(aa,pa,xm)
char *aa; int *pa, *xm;
{
	register a;
	register b;

	a = aa;
	b = ( u.u_sep ? UDSA : UISA )->r[(a>>13)&07] + ((a>>6)&0177);
	*xm = (b>>10) & 077;
	*pa = (b<<6) + (a&077);
}
